---
name: feature-implementation
description: Use when implementing a feature or multi-file code change - provides structured implementation flow with persona selection, validation, and testing guidance.
---

# Feature Implementation

## Overview
Guide feature implementation with clear steps: analyze requirements, plan approach, implement safely, and validate with tests.

## When to Use
- Implementing a feature, component, service, or API
- Coordinating multi-domain changes (UI + API + tests)
- Adding tests alongside implementation

Avoid when:
- The task is a trivial one-line change
- You only need a plan (use implementation-workflow)

## Quick Reference

| Task | Load reference |
| --- | --- |
| Implementation workflow | `skills/feature-implementation/references/implement.md` |

## Workflow
1. Clarify requirements and constraints.
2. Load the implementation reference.
3. Implement changes with appropriate personas/tools.
4. Add or update tests.
5. Validate with builds/tests.

## Output
- Implementation summary
- Validation results and remaining risks

## Common Mistakes
- Implementing without tests or validation
- Skipping integration considerations
- Mixing planning and implementation without agreement
