---
name: git-ops
description: Use when performing git operations or generating smart commit messages - provides safe git workflow guidance, validation checks, and conventional commit formatting.
---

# Git Ops

## Overview
Execute git operations safely while producing clear, conventional commit messages and workflow guidance.

## When to Use
- Running git commands (status, add, commit, push, pull)
- Generating smart commit messages
- Managing branches and merges

Avoid when:
- The task is unrelated to git operations

## Quick Reference

| Task | Load reference |
| --- | --- |
| Git operations | `skills/git-ops/references/git.md` |
| **Branching Strategies** | `skills/git-ops/references/branching-strategies.md` |

## Workflow
1. Confirm repository state and intent.
2. Load the git operations reference.
3. Execute the command safely.
4. Provide status summary and next steps.

## Output
- Operation result summary
- Suggested follow-ups or warnings

## Common Mistakes
- Running destructive commands without confirmation
- Writing non-standard commit messages
