---
name: implementation-workflow
description: Use when turning PRDs or feature specs into actionable implementation workflows - provides structured task decomposition, dependency mapping, and validation gates.
---

# Implementation Workflow

## Overview
Create structured implementation workflows from PRDs or feature requirements. Emphasize clear task breakdowns, dependencies, and validation checkpoints.

## When to Use
- Translating a PRD or feature spec into tasks
- Planning multi-domain implementation work
- Defining validation gates and dependencies

Avoid when:
- The task is a small, obvious change
- You already have a complete plan

## Quick Reference

| Task | Load reference |
| --- | --- |
| Workflow generation | `skills/implementation-workflow/references/workflow.md` |

## Workflow
1. Read the PRD/spec and identify core requirements.
2. Load the workflow reference for structure and patterns.
3. Decompose into workstreams with dependencies.
4. Add validation steps and risk mitigation.
5. Deliver the workflow and next actions.

## Output
- Structured workflow with tasks and dependencies
- Validation checklist and risks

## Common Mistakes
- Skipping dependency mapping
- Mixing execution steps with brainstorming
- Omitting validation gates
