---
name: reasoning-controls
description: Use when adjusting reasoning depth, budgets, or metrics visibility - provides guidance for selecting and applying reasoning controls safely.
---

# Reasoning Controls

## Overview
Control reasoning depth and cost trade-offs using consistent settings and metrics.

## When to Use
- Adjusting reasoning depth or thinking mode
- Setting budget limits for cost or latency
- Reporting reasoning metrics

Avoid when:
- The task doesn’t require explicit reasoning controls

## Quick Reference

| Task | Load reference |
| --- | --- |
| Adjust reasoning | `skills/reasoning-controls/references/adjust.md` |
| Budget controls | `skills/reasoning-controls/references/budget.md` |
| Metrics reporting | `skills/reasoning-controls/references/metrics.md` |

## Workflow
1. Determine the control goal (depth, budget, metrics).
2. Load the matching reference.
3. Apply the control with the appropriate parameters.
4. Report settings and effects.

## Output
- Updated reasoning settings
- Metrics or confirmation output

## Common Mistakes
- Over-allocating budget for simple tasks
- Changing depth without explaining trade-offs
