---
name: task-orchestration
description: Use when coordinating complex tasks with orchestration, delegation, or parallel workstreams - provides structured workflows for orchestrate:brainstorm, orchestrate:spawn, and orchestrate:task.
---

# Task Orchestration

## Overview
Coordinate complex tasks with structured orchestration: discover requirements, spawn parallel agents, and execute multi-step workflows with validation.

## When to Use
- Multi-step tasks requiring coordination or delegation
- Parallelizable workstreams
- Complex requirements discovery

Avoid when:
- The task is simple or single-file

## Quick Reference

| Task | Load reference |
| --- | --- |
| Orchestrated brainstorming | `skills/task-orchestration/references/brainstorm.md` |
| Spawn orchestration | `skills/task-orchestration/references/spawn.md` |
| Task orchestration | `skills/task-orchestration/references/task.md` |
| **Process Patterns** | `skills/task-orchestration/references/process-patterns.md` |
| **Task Decomposition** | `skills/task-orchestration/references/task-decomposition.md` |

## Workflow
1. Choose the orchestration mode (brainstorm, spawn, task).
2. Load the matching reference.
3. Execute with delegation and progress tracking.
4. Validate outputs and consolidate results.

## Output
- Orchestration summary
- Task progress and next steps

## Common Mistakes
- Spawning without clear task boundaries
- Skipping validation gates
