# Aesthetic Guidelines

**Goal:** Avoid generic "AI slop". Make distinctive, high-quality choices.

## Typography
- **Avoid:** Inter, Roboto, Open Sans, Arial, system defaults.
- **Use:**
    - *Code:* JetBrains Mono, Fira Code, Space Grotesk.
    - *Editorial:* Playfair Display, Crimson Pro, Fraunces.
    - *Startup:* Clash Display, Satoshi, Cabinet Grotesk.
    - *Technical:* IBM Plex family, Source Sans 3.
- **Weights:** Use extremes (100 vs 900) for contrast. Avoid safe middles (400 vs 600).

## Color & Theme
- **Commit:** Choose a cohesive aesthetic (Solarpunk, Swiss Style, Brutalism, Glassmorphism).
- **Avoid:** Soft purple gradients on white backgrounds.
- **Contrast:** High contrast accents on neutral bases.

## Motion
- **Performance:** CSS-only transforms and opacity.
- **Choreography:** Staggered page load reveals (`animation-delay`).
- **Feel:** Snappy (spring physics) over linear.

## Backgrounds
- **Depth:** Layered gradients, noise textures, geometric patterns.
- **Avoid:** Flat, sterile solid colors.
