---
name: plan
description: Enter planning mode to research and analyze before implementation. Use when user wants to plan a feature, evaluate a technical approach, explore architectural decisions, or think through implementation before coding. Triggers on "plan", "think through", "analyze", "evaluate approach", "design decision", "before we implement", "let's research", or when proposing significant changes.
---

# Planning Mode

Enter planning mode to research, analyze, and document a considered approach before implementation. Output a plan document to `.work/plans/backlog/<name>.md`.

## Planning Workflow

### 1. Understand the Request

Clarify what needs planning:
- What problem are we solving?
- What constraints exist (time, tech stack, team familiarity)?
- Is there prior art in this codebase?

Ask clarifying questions before researching.

### 2. Research the Codebase

Investigate relevant areas:
- Existing patterns and conventions
- Related implementations
- Database schema and data models
- API contracts and boundaries
- Configuration and environment requirements

Use `codebase_search`, `grep`, and `read_file` to gather context.

### 3. Research Technologies

When introducing or evaluating technologies:
- Fetch current documentation using available tools
- Check compatibility with existing stack (Node.js, TypeScript, pnpm, etc.)
- Evaluate maturity, maintenance status, bundle size implications

### 4. Analyze Trade-offs

For each approach considered:
- **Benefits**: What problems does it solve well?
- **Drawbacks**: What complexity or limitations does it introduce?
- **Risks**: What could go wrong? Migration paths?
- **Alternatives**: What else was considered and why not?

### 5. Write the Plan

Create `.work/plans/backlog/<descriptive-name>.md` with:

```markdown
# Plan: <Title>

**Status:** Draft | Review | Approved
**Created:** <date>
**Author:** <who requested>

## Context

What triggered this plan? Link to conversations, issues, or user requests.

## Problem Statement

One paragraph: what problem are we solving and why it matters.

## Research Findings

### Codebase Analysis
- Relevant existing patterns
- Files/modules that will be affected
- Current state vs desired state

### Technology Evaluation
- Options considered
- Compatibility notes
- Documentation links

## Proposed Approach

Clear description of the recommended solution.

### Why This Approach
- Key benefits
- How it fits existing patterns

### Trade-offs Accepted
- Known limitations
- Complexity being introduced

### Alternatives Considered

| Approach | Pros | Cons | Why Not |
|----------|------|------|---------|
| ... | ... | ... | ... |

## Open Questions

- Unresolved decisions needing input
- Areas requiring more research
- Questions for the team

## Next Steps

- [ ] Specific actionable items
- [ ] Who needs to review/approve
- [ ] Dependencies or blockers
```

## Output Guidelines

- **Be concise**: Developers will read this. Respect their time.
- **Be specific**: Link to actual files, functions, line numbers.
- **Be honest**: Surface unknowns and risks clearly.
- **Be decisive**: Recommend an approach, don't just list options.

## When Planning Completes

After writing the plan:
1. Summarize the recommendation to the user
2. Highlight key trade-offs and open questions
3. Ask if they want to proceed, modify, or research further
4. If approved, the plan can be used to generate tasks via the `task` skill

