---
name: landing-page-copywriter
description: Write high-converting landing page copy using proven frameworks like PAS (Problem-Agitate-Solution), AIDA, and StoryBrand. Creates headlines, value propositions, CTAs, and full page sections optimized for conversion. Use when users need landing page copy, sales page content, or marketing website text.
---

# Landing Page Copywriter

Create high-converting landing page copy using proven copywriting frameworks.

## Instructions

When a user needs landing page copy or marketing website content:

1. **Gather Product/Service Information**:
   - What product/service are you selling?
   - Who is your target audience?
   - What problem does it solve?
   - What makes it unique (competitive advantage)?
   - What action do you want visitors to take?
   - Any social proof, testimonials, or data points?

2. **Choose Copywriting Framework**:

   **PAS (Problem-Agitate-Solution)**:
   - Identify the pain point
   - Amplify the consequences
   - Present your solution

   **AIDA (Attention-Interest-Desire-Action)**:
   - Grab attention with bold claim
   - Build interest with details
   - Create desire with benefits
   - Prompt action with CTA

   **StoryBrand**:
   - Hero (customer) has a problem
   - Meets a guide (you)
   - Who gives them a plan
   - Calls them to action
   - That results in success/avoids failure

3. **Generate Landing Page Sections**:

   **Hero Section**:
   - Headline (value proposition in 10 words or less)
   - Subheadline (expand on the value)
   - Primary CTA button text
   - Trust indicators (used by X companies, Y reviews)

   **Problem Section**:
   - Identify the pain point your audience feels
   - Use emotional language
   - 2-3 specific scenarios

   **Solution Section**:
   - How your product solves the problem
   - 3-5 key features with benefit-focused descriptions
   - Why it's better than alternatives

   **How It Works**:
   - 3-4 simple steps
   - Each step has icon concept + description
   - End with CTA

   **Social Proof**:
   - Testimonial structure (quote + name + role + company)
   - Case study snippet
   - Trust badges or metrics

   **Pricing/Plans** (if applicable):
   - Feature comparison
   - Recommended plan highlighting
   - Money-back guarantee copy

   **FAQ**:
   - 5-7 common objections
   - Clear, confident answers

   **Final CTA**:
   - Urgency or scarcity element
   - Risk reversal (guarantee)
   - Button text that reinforces value

4. **Format Output**:
   ```
   🎯 LANDING PAGE COPY
   Product/Service: [Name]
   Framework: [PAS/AIDA/StoryBrand]

   ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
   🏆 HERO SECTION
   ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

   Headline: [Powerful 10-word value proposition]

   Subheadline: [2-sentence expansion]

   CTA Button: "[Action-oriented text]"

   Trust Bar: [Social proof element]

   ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
   😤 PROBLEM SECTION
   ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

   [Problem description with emotional resonance]

   ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
   ✅ SOLUTION SECTION
   ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

   [How your product solves it]

   Feature 1: [Benefit-focused description]
   Feature 2: [Benefit-focused description]
   Feature 3: [Benefit-focused description]

   ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
   🔄 HOW IT WORKS
   ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

   Step 1: [Simple action]
   Step 2: [Simple action]
   Step 3: [Simple action]

   ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
   ⭐ SOCIAL PROOF
   ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

   [Testimonial quotes with attribution]

   ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
   ❓ FAQ
   ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

   Q: [Common objection]
   A: [Clear, confident answer]

   ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
   🚀 FINAL CTA
   ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

   [Urgency/scarcity element]
   [Risk reversal]
   Button: "[Action text]"

   ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
   💡 OPTIMIZATION NOTES
   ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

   A/B Test Ideas:
   • [Headline variation]
   • [CTA variation]

   Conversion Tips:
   • [Specific recommendation]
   ```

5. **Copywriting Best Practices**:
   - Use active voice, present tense
   - Focus on benefits, not features
   - Include specific numbers and data
   - Address objections directly
   - Create urgency without being pushy
   - Use power words (proven, guaranteed, instant, effortless)
   - Keep sentences short and scannable
   - Use "you" language (customer-focused)
   - Include multiple CTAs throughout page

6. **CTA Button Best Practices**:
   - Start with action verb
   - Be specific about outcome
   - Use first person when appropriate ("Start My Free Trial" vs "Start Your Free Trial")
   - Create urgency ("Get Instant Access")
   - Avoid generic text ("Submit", "Click Here")

## Example Triggers

- "Write landing page copy for a B2B SaaS tool"
- "Create sales page content using PAS framework"
- "Generate hero section copy for my product"
- "Write conversion-optimized CTAs"
- "Help me with landing page headlines"

## Output Quality

Ensure all copy:
- Leads with value, not features
- Addresses target audience pain points
- Uses emotional and logical appeals
- Has clear, compelling CTAs
- Includes social proof elements
- Handles objections proactively
- Creates urgency appropriately
- Is scannable and easy to read
- Uses proven copywriting frameworks
- Follows conversion optimization best practices

Generate professional, high-converting landing page copy that turns visitors into customers.
