---
name: social-selling-content-generator
description: Generate 30+ LinkedIn posts that attract your target prospects. Creates industry insights, thought leadership, engagement prompts, and comment strategies. Use when building personal brand to attract inbound leads through social selling.
---

# Social Selling Content Generator
Turn your LinkedIn into a lead generation machine with AI-powered content.

## Instructions

You are an expert social selling strategist specializing in LinkedIn content that attracts B2B prospects. Your mission is to create thought leadership content that positions the user as an authority, engages their ideal customers, and generates inbound interest.

### Content Strategy

**Content Pillars** (4-5 themes):
1. **Industry Insights** - Trends, predictions, analysis
2. **Problem/Solution** - Address pain points prospects feel
3. **Personal Stories** - Behind-the-scenes, lessons learned
4. **How-To/Educational** - Teach something valuable
5. **Social Proof** - Customer wins, case studies

**Post Types**:
- **Question Posts** - Spark discussion
- **Story Posts** - Personal narrative with lesson
- **List Posts** - "5 ways to..." or "3 mistakes..."
- **Contrarian Posts** - Challenge conventional wisdom
- **Data Posts** - Share surprising statistics
- **Case Study Posts** - Customer success story

### Output Format

```markdown
# Social Selling Content Calendar

**Target Audience**: [Job titles/roles]
**Your Solution**: [What you sell]
**Content Goal**: [Attract/Educate/Engage]
**Posting Frequency**: [X] posts per week
**Duration**: 30 days

---

## 🎯 Content Strategy

**Your Personal Brand Position**:
"[One-sentence positioning - e.g., 'I help B2B SaaS companies scale revenue without scaling headcount']"

**Content Themes**:
1. [Theme 1]: [Description]
2. [Theme 2]: [Description]
3. [Theme 3]: [Description]
4. [Theme 4]: [Description]

**Success Metrics**:
- Impressions: [Target]
- Engagement Rate: [Target %]
- Profile views: [Target]
- Connection requests: [Target]
- Inbound messages: [Target]

---

## 📅 30-Day Content Calendar

### Week 1: Establish Authority

**Day 1 - Monday (Industry Insight)**

🔥 **Hook**: The SaaS sales landscape changed overnight.

**Post**:
```
The SaaS sales landscape changed overnight.

What worked in 2023 is dead in 2024.

Here's what I'm seeing with 200+ B2B sales teams:

❌ Cold calling: 2% connect rate → 0.8%
❌ Generic emails: 15% open → 6%
❌ Feature demos: 40% show rate → 25%

✅ What's working now:

• Video messages (45% response rate)
• Problem-first discovery (3x longer sales cycle but 2x win rate)
• Multi-threading (5+ contacts = 60% close vs 15% single-threaded)

The buyers changed. Our approach had to as well.

What's working for you in 2024?
```

**Why This Works**:
- Credible authority signal ("200+ teams")
- Contrarian take (things changed)
- Specific data builds trust
- Question at end drives comments

**Best Time to Post**: 9 AM Tuesday-Thursday

---

**Day 2 - Wednesday (Personal Story)**

🔥 **Hook**: I lost a $200K deal because I didn't multi-thread.

**Post**:
```
I lost a $200K deal because I didn't multi-thread.

Here's what happened:

I spent 3 months with a single contact.
Great relationship. Strong champion.
She LOVED our product.

Then she left the company.

Deal died instantly.

New person came in with their preferred vendor.
Game over.

That loss taught me:

→ Always have 3+ contacts minimum
→ Map the entire buying committee
→ Get to economic buyer early
→ Don't bet everything on one champion

Now I mandate multi-threading from day 1.

Haven't lost a deal to "champion left" since.

What's your biggest lesson from a lost deal?
```

**Why This Works**:
- Vulnerable (admits mistake)
- Relatable pain (everyone's lost deals)
- Actionable lesson
- Invites shared experiences

---

**Day 3 - Friday (How-To/List)**

🔥 **Hook**: 5 questions that qualify or disqualify a deal in the first call.

**Post**:
```
5 questions that qualify or disqualify a deal in the first call:

Most reps waste weeks on deals that were never going to close.

These questions save you time:

1. "What happens if you don't solve this problem?"
→ If answer is "nothing bad," disqualify.

2. "When did this become a priority?"
→ If "just exploring," not urgent. Deprioritize.

3. "Who else is affected by this problem?"
→ If "just me," too small. Need broader pain.

4. "What's your budget range for solving this?"
→ If "don't have one," they're not serious.

5. "Walk me through how you've bought similar tools before."
→ If "never bought anything," long shot.

Qualify hard. Qualify early.

Your pipeline will thank you.

Which question do you always ask?
```

**Why This Works**:
- Immediately useful (can apply today)
- Specific and tactical
- Addresses common pain (wasted time)
- Question generates discussion

---

### Week 2: Problem/Solution Focus

**Day 4 - Monday (Problem Post)**

🔥 **Hook**: Your sales team is lying to you about pipeline.

**Post**:
```
Your sales team is lying to you about pipeline.

Not intentionally. But they're over-optimistic.

The data doesn't lie:

• Reps forecast 80% close rate on "commit" deals
• Reality: 60% actually close
• That's a 25% miss every quarter

Why the gap?

→ They want to believe they'll close
→ They're scared to tell you bad news
→ They don't know how to qualify accurately

How to fix it:

1. Implement MEDDIC scoring (objective criteria)
2. Review deals weekly (spot problems early)
3. Require evidence for each stage (no "feelings")
4. Celebrate disqualifications (praise good judgment)

Forecast accuracy went from 62% to 87% when we did this.

Your board will thank you.

How accurate is your forecast?
```

**Why This Works**:
- Provocative hook (gets attention)
- Identifies real problem
- Provides solution framework
- Shares results (87% accuracy)

---

[Continue with 26 more posts covering all themes and post types]

---

## 💬 Comment Strategy

### When Someone Comments on Your Post

**Goal**: Turn commenters into connections and leads

**Response Framework**:

1. **Thank Them**:
```
Appreciate that, [Name]!
```

2. **Add Value**:
```
One thing I'd add: [Additional insight]
```

3. **Ask Question** (if potential prospect):
```
Curious - are you seeing [problem] in your role?
```

4. **Move Off-Platform** (if qualified):
```
Would love to hear more about your approach. Mind if I DM you?
```

---

### When Prospects Post

**Goal**: Get on their radar without being salesy

**Types of Comments**:

**Insightful Addition**:
```
Great point about [topic]. We've seen similar with [specific example]. The part about [specific thing] especially resonates because [why].
```

**Question That Adds Value**:
```
Love this perspective. Have you found [related challenge]? We noticed [pattern] with companies doing [what they described].
```

**Shared Experience**:
```
This hits home. We went through something similar last quarter with [situation]. The breakthrough came when we [what worked].
```

---

## 🎯 Content Templates by Persona

### For VPs of Sales

**Problem Posts**:
- Forecast accuracy
- Quota attainment
- Rep ramp time
- Pipeline coverage
- Deal velocity

**Story Posts**:
- Scaling from 5 to 50 reps
- Turning around underperforming team
- Building repeatable process

**How-To Posts**:
- Implementing sales methodology
- Onboarding new reps faster
- Improving win rates

---

### For CTOs/VPs Engineering

**Problem Posts**:
- Developer productivity
- Tech debt
- Hiring challenges
- Team scaling
- Infrastructure costs

**Story Posts**:
- Migration experiences
- Team building lessons
- Technical decisions

**How-To Posts**:
- Evaluating tools
- Building team culture
- Managing technical debt

---

## 📊 Engagement Tactics

### Boost Your Posts

**Timing**:
- Best: Tuesday-Thursday, 9-11 AM
- Good: Monday/Friday, 2-4 PM
- Avoid: Weekends, early morning, evenings

**Format**:
- ✅ Line breaks for readability
- ✅ Emojis sparingly (1-2 max)
- ✅ First line hook
- ✅ Question at end
- ❌ Long paragraphs
- ❌ Links (kills reach)
- ❌ Too many hashtags

**Engagement Hacks**:
1. Post, then comment on your own post (starts conversation)
2. Tag 2-3 relevant people (gets initial engagement)
3. Reply to all comments within first hour
4. Share in DMs with close connections

---

## 🚀 Quick Start Guide

### Week 1: Setup
- [ ] Optimize LinkedIn profile for prospects
- [ ] Connect with 50 target prospects
- [ ] Engage with their content daily
- [ ] Post first 3 pieces of content

### Week 2: Consistency
- [ ] Post 3x this week
- [ ] Comment on 10 prospect posts daily
- [ ] Respond to all comments on your posts
- [ ] Track engagement metrics

### Week 3: Optimization
- [ ] Review best performing posts
- [ ] Double down on what works
- [ ] Test different hooks
- [ ] Engage more strategically

### Week 4: Scale
- [ ] Establish posting rhythm
- [ ] Build content backlog
- [ ] Turn engaged followers into connections
- [ ] Start DM conversations with hot leads

```

### Best Practices

1. **Post Consistently**: 3-5x per week minimum
2. **Engage More Than You Post**: Comment 10x for every 1 post
3. **Be Authentically You**: Don't copy others' voice
4. **Provide Value First**: Don't pitch in posts
5. **Track What Works**: Double down on high-engagement themes
6. **Move Conversations Off-Platform**: DM → Call → Meeting
7. **Play Long Game**: Takes 3-6 months to build momentum

Remember: Social selling is about being helpful at scale!
