# Agent Docs

Static agent-only references for planning, prompting, and implementation support.

If you just want to load the extension in Revit (no coding), start here:
- [`CodexWorkspace/human/README.md`](../../../human/README.md)

## Core Workflow
- AI-orchestrated methodology: [`agent_ai_orchestrated_dev_methodology.md`](agent_ai_orchestrated_dev_methodology.md)
- Dev workflow: [`agent_dev_workflow.md`](agent_dev_workflow.md)
- Prompting guidelines: [`agent_llm_prompting_guidelines.md`](agent_llm_prompting_guidelines.md)
- Performance notes: [`agent_performance_notes.md`](agent_performance_notes.md)

## pyRevit Guides (Agent Only)
- Index: [`pyrevit_overview.md`](pyrevit_overview.md)

## Versioned Revit Skills
- Revit 2023 guidance: [`CodexWorkspace/skills/pyrevit-revit-2023/`](../../pyrevit-revit-2023/)
- Revit 2024 guidance (scaffold): [`CodexWorkspace/skills/pyrevit-revit-2024/`](../../pyrevit-revit-2024/)
- Revit 2025 guidance (scaffold): [`CodexWorkspace/skills/pyrevit-revit-2025/`](../../pyrevit-revit-2025/)

## Checklists (Agent Only)
- [`checklists_overview.md`](checklists_overview.md)

## Templates (Agent Only)
- [`templates_overview.md`](templates_overview.md)

## Scripts (Agent Only)
- [`scripts_overview.md`](scripts_overview.md)

## Workspace Outputs
- Planning artifacts live in [`CodexWorkspace/workspace/`](../../../workspace/).

Return back: [`docs_overview.md`](docs_overview.md)
Return to root: [`README.md`](../../../../README.md)
