# Skill References Index

This folder is the navigation layer for the `develop-pyrevit-extensions` skill references.

## Human Guides (Template Usage)
- Start Here: [`CodexWorkspace/human/README.md`](../../../human/README.md)
- Beginner quickstart: [`CodexWorkspace/human/beginner_quickstart.md`](../../../human/beginner_quickstart.md)
- Advanced workflow: [`CodexWorkspace/human/advanced_workflow.md`](../../../human/advanced_workflow.md)
- Environment setup: [`CodexWorkspace/human/environment_setup.md`](../../../human/environment_setup.md)
- Troubleshooting: [`CodexWorkspace/human/troubleshooting.md`](../../../human/troubleshooting.md)

## Agent Docs
- Agent index: [`agent_overview.md`](agent_overview.md)
- AI-orchestrated methodology: [`agent_ai_orchestrated_dev_methodology.md`](agent_ai_orchestrated_dev_methodology.md)
- Dev workflow: [`agent_dev_workflow.md`](agent_dev_workflow.md)
- Prompting guidelines: [`agent_llm_prompting_guidelines.md`](agent_llm_prompting_guidelines.md)
- Performance notes: [`agent_performance_notes.md`](agent_performance_notes.md)
- Logging and debugging standards: [`logging_and_debugging.md`](logging_and_debugging.md)
- pyRevit guides: [`pyrevit_overview.md`](pyrevit_overview.md)

## Versioned Revit Skills
- Revit 2023 guidance: [`CodexWorkspace/skills/pyrevit-revit-2023/`](../../pyrevit-revit-2023/)
- Revit 2024 guidance (scaffold): [`CodexWorkspace/skills/pyrevit-revit-2024/`](../../pyrevit-revit-2024/)
- Revit 2025 guidance (scaffold): [`CodexWorkspace/skills/pyrevit-revit-2025/`](../../pyrevit-revit-2025/)

## Helper Skills
- SVG-only icon selection with vision coupling: [`CodexWorkspace/skills/select-svg-icon/`](../../select-svg-icon/)

## Agent Assets
- Checklists: [`checklists_overview.md`](checklists_overview.md)
- Templates: [`templates_overview.md`](templates_overview.md)
- Prompts: [`prompts_overview.md`](prompts_overview.md)
- Scripts: [`scripts_overview.md`](scripts_overview.md)

## Workspace (Project-Specific)
- Overview: [`CodexWorkspace/workspace/README.md`](../../../workspace/README.md)
- Development plan: [`CodexWorkspace/workspace/development.md`](../../../workspace/development.md)
- Backlog: [`CodexWorkspace/workspace/backlog.md`](../../../workspace/backlog.md)
- PRD (advanced overlay): [`CodexWorkspace/workspace/prd.md`](../../../workspace/prd.md)
- Tech spec (advanced overlay): [`CodexWorkspace/workspace/tech_spec.md`](../../../workspace/tech_spec.md)
- Status (advanced overlay): [`CodexWorkspace/workspace/status.md`](../../../workspace/status.md)
- Plans: [`CodexWorkspace/workspace/plans/`](../../../workspace/plans/)
- Tasks: [`CodexWorkspace/workspace/tasks/`](../../../workspace/tasks/)
- Reviews: [`CodexWorkspace/workspace/reviews/`](../../../workspace/reviews/)

Return back: [`CodexWorkspace/README.md`](../../../README.md)
Return to root: [`README.md`](../../../../README.md)
