---
name: pact-agent-teams
description: |
  Agent Teams interaction protocol for PACT specialist agents. Auto-loaded via agent frontmatter.
  Defines how teammates start work, communicate, report completion, and handle blockers.
---

# Agent Teams Protocol

> **Architecture**: See [pact-task-hierarchy.md](../../protocols/pact-task-hierarchy.md) for the full hierarchy model.

## You Are a Teammate

You are a member of a PACT Agent Team. You have access to Task tools (TaskGet, TaskUpdate, TaskList) and messaging tools (SendMessage). Use them to coordinate with the team.

## On Start

1. Check `TaskList` for tasks assigned to you (by your name)
2. Claim your assigned task: `TaskUpdate(taskId, status="in_progress")`
3. Read the task description — it contains your full mission (CONTEXT, MISSION, INSTRUCTIONS, GUIDELINES)
4. Begin work

> **Note**: The lead stores your `agent_id` in task metadata after dispatch. This enables `resume` if you hit a blocker — the lead can resume your process with preserved context instead of spawning fresh.

## Reading Upstream Context

Your task description may reference upstream task IDs (e.g., "Architect task: #5").
Use `TaskGet(taskId)` to read their metadata for design decisions, HANDOFF data, and
integration points — rather than relying on the lead to relay this information.

Common chain-reads:
- **Coders** → read architect's task for design decisions and interface contracts
- **Test engineers** → read coder tasks for what was built and flagged uncertainties
- **Reviewers** → read prior phase tasks for full context

If TaskGet returns no metadata or the referenced task doesn't exist, proceed with information from your task description and file system artifacts (docs/architecture/, docs/preparation/).

## Teachback (Conversation Verification)

After reading upstream context (TaskGet on referenced tasks), send a **teachback message** to the lead before starting work. This verifies your understanding of the upstream conversation.

**Format**:
```
SendMessage(type="message", recipient="lead",
  content="[{sender}→lead] Teachback:\n- Building: {what you understand you're building}\n- Key constraints: {constraints you're working within}\n- Interfaces: {interfaces you'll produce or consume}\n- Approach: {your intended approach, briefly}\nProceeding unless corrected.",
  summary="Teachback: {1-line summary}")
```

**Rules**:
- Send teachback as your **first message** after reading upstream handoffs
- Keep it concise: 3-6 bullet points
- **Non-blocking**: Proceed with work immediately after sending — don't wait for confirmation
- If the lead sends a correction, adjust your approach as soon as you see it

**When**: Always when dispatched with upstream task references. Optional for self-claimed follow-up tasks. Not needed for consultant questions.

Background: [pact-ct-teachback.md](../../protocols/pact-ct-teachback.md) (optional — protocol rationale and design history).

## Progress Reporting

Report progress naturally in your responses. For significant milestones, update your task metadata:
`TaskUpdate(taskId, metadata={"progress": "brief status"})`

## Message Prefix Convention

**Prefix all SendMessage `content`** with `[{sender}→{recipient}]` (use `all` as recipient when `type="broadcast"`). Do not prefix `summary`.

## On Completion — HANDOFF (Required)

When your work is done:

1. **Store HANDOFF in task metadata**:
   ```
   TaskUpdate(taskId, metadata={"handoff": {
     "produced": [...],
     "decisions": [...],
     "reasoning_chain": "...",  // recommended — include unless task is trivial
     "uncertainty": [...],
     "integration": [...],
     "open_questions": [...]
   }})
   ```
   If TaskUpdate fails, include the full HANDOFF in your SendMessage content as a fallback.
2. **Notify lead with summary only**:
   ```
   SendMessage(type="message", recipient="lead",
     content="[{sender}→lead] Task complete. [1-2 sentences: what was done + any HIGH uncertainties]",
     summary="Task complete: [brief]")
   ```
3. **Mark task completed**:
   `TaskUpdate(taskId, status="completed")`
4. **Self-claim follow-up work**: Check `TaskList` for unassigned, unblocked tasks matching your domain
5. If found: `TaskUpdate(taskId, owner="your-name", status="in_progress")` and begin
6. If none: idle (you may be consulted or shut down)

### HANDOFF Format

End every response with a structured HANDOFF. This is mandatory.
This HANDOFF must ALSO be stored in task metadata (see On Completion Step 1 above). The prose version in your response ensures validate_handoff hook compatibility; the metadata version enables chain-read by downstream agents.

```
HANDOFF:
1. Produced: Files created/modified
2. Key decisions: Decisions with rationale, assumptions that could be wrong
3. Reasoning chain (optional): How key decisions connect — "X because Y, which required Z." Helps downstream agents reconstruct your understanding, not just your conclusions.
4. Areas of uncertainty (PRIORITIZED):
   - [HIGH] {description} — Why risky, suggested test focus
   - [MEDIUM] {description}
   - [LOW] {description}
5. Integration points: Other components touched
6. Open questions: Unresolved items
```

Items 1-2 and 4-6 are required. Item 3 (reasoning chain) is recommended — include it unless the task is trivial. Not all priority levels need to be present in Areas of uncertainty. If you have no uncertainties, explicitly state "No areas of uncertainty flagged."

## Peer Communication

Use `SendMessage(type="message", recipient="teammate-name")` for direct coordination.
Discover teammates via `~/.claude/teams/{team-name}/config.json` or from peer names
in your task description.

**Message a peer when:**
- Your work produces something an active peer needs (API schema, interface contract, shared config)
- You have a question another specialist can answer better than the lead
- You discover something affecting a peer's scope (breaking change, shared dependency)

**Message the lead when:**
- Blockers, algedonic signals, completion summaries (always)
- Questions about scope, priorities, or requirements
- Anything requiring a decision above your authority

Keep messages actionable — state what you did/found, what they need to know, and
any action needed from them.
Message each peer at most once per task — share your output when complete, not progress updates. If you need ongoing coordination, route through the lead.

## Consultant Mode

When your active task is done and no follow-up tasks are available:
- You are a **consultant** — remain available for questions
- Respond to `SendMessage` questions from other teammates
- Do NOT seek new work outside your domain
- Do NOT proactively message unless you spot a problem relevant to active work

## On Blocker

If you cannot proceed:

1. **Stop work immediately**
2. **SendMessage** the blocker to the lead:
   ```
   SendMessage(type="message", recipient="lead",
     content="[{sender}→lead] BLOCKER: {description of what is blocking you}\n\nPartial HANDOFF:\n...",
     summary="BLOCKER: [brief description]")
   ```
3. Provide a partial HANDOFF with whatever work you completed
4. Wait for lead's response or new instructions

Do not attempt to work around the blocker.

## Algedonic Signals

When you detect a viability threat (security, data integrity, ethics):

1. **Stop work immediately**
2. **SendMessage** the signal to the lead:
   ```
   SendMessage(type="message", recipient="lead",
     content="[{sender}→lead] ⚠️ ALGEDONIC [HALT|ALERT]: {Category}\n\nIssue: ...\nEvidence: ...\nImpact: ...\nRecommended Action: ...\n\nPartial HANDOFF:\n...",
     summary="ALGEDONIC [HALT|ALERT]: [category]")
   ```
3. Provide a partial HANDOFF with whatever work you completed

These bypass normal triage. See the [algedonic protocol](../../protocols/algedonic.md) for trigger categories and severity guidance.

## Variety Signals

If task complexity differs significantly from what was delegated:
- "Simpler than expected" — Note in handoff; lead may simplify remaining work
- "More complex than expected" — Escalate if scope change >20%, or note for lead

## Before Completing

Before returning your final output:

1. **Save Project Memory**: Invoke the `pact-memory` skill to save **project-wide institutional knowledge**:
   - Context: What you were working on and why
   - Goal: What you were trying to achieve
   - Lessons learned: What worked, what didn't, gotchas discovered
   - Decisions: Key choices made with rationale
   - Entities: Components, files, services involved

This saves cross-agent, cross-session knowledge searchable by future agents. For **agent-level domain learnings** (patterns you personally encounter, debugging tricks, domain expertise), use your persistent memory directory (`~/.claude/agent-memory/<your-name>/`) — this is managed automatically by the SDK `memory: user` frontmatter in your agent definition.

## Shutdown

When you receive a `shutdown_request`:

| Situation | Response |
|-----------|----------|
| Idle, consultant with no active questions, or domain no longer relevant | Approve |
| Mid-task, awaiting response, or remediation may need your input | Reject with reason |

> **Save memory before approving**: If you haven't already saved project-wide knowledge via `pact-memory`, do so before approving — your process terminates on approval. Agent-level learnings in your persistent memory directory are saved automatically.

## Completion Integrity (SACROSANCT)

Only report work as completed if you actually performed the changes. Never fabricate
a completion HANDOFF. If files don't exist, can't be edited, or tools fail, report
a BLOCKER via SendMessage -- never invent results.
