# Development Workflows

Based on the project structure and common development practices.

## Project Structure

```
cetus-dlmm-interface/
├── packages/dlmm/              # Move smart contracts
│   ├── Move.toml              # Package manifest
│   ├── Move.lock              # Dependency lock file
│   ├── README.md              # Package documentation
│   └── sources/               # 15 Move modules
├── sdk/swap-sdk/              # Rust SDK
│   ├── Cargo.toml            # Rust package manifest
│   ├── Cargo.lock            # Rust dependency lock
│   ├── README.md             # SDK documentation
│   └── src/                  # SDK source code
└── CLAUDE.md                 # Project-specific development guidelines
```

## Essential Commands

### Move Development

**Build:**
```bash
cd packages/dlmm
sui move build --skip-fetch-latest-git-deps
```

**Test:**
```bash
sui move test
```

**Format:**
```bash
bunx prettier-move -c *.move --write
```

### Rust SDK Development

**Build:**
```bash
cd sdk/swap-sdk
cargo build
```

**Test:**
```bash
cargo test
```

**Format:**
```bash
cargo fmt
```

**Lint:**
```bash
cargo clippy -- -D warnings
```

## Development Guidelines

Follow the comprehensive guidelines in `CLAUDE.md` for:
- Move 2024 edition patterns
- Code organization and structure
- Error handling and constants
- Testing best practices

## Source Code Reference

Always refer to the actual source files for accurate information:
- Move modules: `packages/dlmm/sources/`
- Rust SDK: `sdk/swap-sdk/src/`
- Project guidelines: `CLAUDE.md`