# Error Codes Reference

Based on actual error constants in `packages/dlmm/sources/`.

## Overview

The DLMM protocol uses descriptive error constants following Move 2024 practices:
- **Naming**: `EPascalCase` (e.g., `EPoolIsBlocked`, `ENotEnoughLiquidity`)
- **Values**: ASCII string constants describing the error
- **Organization**: Each module defines its own error codes

## Error Code Examples

### pool.move Examples
- `EPoolIsBlocked`: "Pool is blocked"
- `ENotEnoughLiquidity`: "Not enough liquidity"
- `EInvalidAmountsOrBinsLength`: "Invalid amounts or bins length"
- `EFlashSwapRepayNotMatch`: "Flash swap repay not match"
- `ERewardTypeNotPermitted`: "Reward type not permitted"

### config.move Examples
- `EInvalidRoleCode`: "Invalid role code"
- `ENoRestrictionManagerPermission`: "No restriction manager permission"
- `EUserIsBlocked`: "User is blocked"
- `EPositionIsBlocked`: "Position is blocked"

### position.move Examples
- `EPositionPoolNotMatch`: "Position pool not match"
- `EPositionNotExists`: "Position not exists"
- `EPositionIsBlocked`: "Position is blocked"

## Complete Error List

For the complete list of error codes, refer to the actual source files:

```bash
# View all error constants
grep -n "const E[A-Z]" packages/dlmm/sources/*.move
```

## Important Notes

- Error constants are defined as `const` with `vector<u8>` values
- Each module has its own error namespace
- Error codes follow consistent naming conventions
- Always check the actual source files for the most current error codes

## Source Code Reference

Error constants are defined in each Move module in `packages/dlmm/sources/`. Always refer to the source files for accurate and up-to-date error information.