# SDK API Reference

Based on the official Cetus Swap SDK README and actual source code in `sdk/swap-sdk/src/`.

## Overview

The Cetus Swap SDK is a lightweight Rust library for DLMM swap pricing logic. It provides accurate swap simulations and price impact calculations without blockchain dependencies.

## Core Structures

### Pool Structure
```rust
pub struct Pool {
    pub active_id: i32,               // Current active bin ID
    pub base_fee_rate: u64,           // Base fee rate (precision: 1e9)
    pub v_parameters: VariableParameters, // Variable fee parameters
    pub bins: Vec<Bin>,               // Array of bins in the pool
}
```

### SwapResult Structure
```rust
pub struct SwapResult {
    pub amount_in: u64,       // Total input amount
    pub amount_out: u64,      // Total output amount
    pub fee: u64,            // Total fee amount
    pub ref_fee: u64,        // Referral fee amount
    pub protocol_fee: u64,   // Protocol fee amount
    pub steps: Vec<BinSwap>, // Individual bin swap steps
    pub is_exceed: bool,     // Whether swap exceeded liquidity
}
```

### Bin Structure
```rust
pub struct Bin {
    pub id: i32,            // Bin ID
    pub amount_x: u64,      // Token X liquidity
    pub amount_y: u64,      // Token Y liquidity
    pub price: u128,        // Bin price (Q64x64 format)
}
```

## Core Functions

### `Pool::swap_exact_amount_in`
```rust
pub fn swap_exact_amount_in(
    &mut self,
    amount_in: u64,
    a2b: bool,
    current_timestamp: u64,
) -> Result<SwapResult, Error>
```

Executes a swap with exact input amount.

### `Pool::swap_exact_amount_out`
```rust
pub fn swap_exact_amount_out(
    &mut self,
    amount_out: u64,
    a2b: bool,
    current_timestamp: u64,
) -> Result<SwapResult, Error>
```

Executes a swap with exact output amount.

## Module Structure

- **`lib.rs`** - Main exports and constants
- **`pool.rs`** - Main swap orchestration and pool management
- **`bin.rs`** - Individual bin swap logic
- **`config.rs`** - Configuration structures
- **`error.rs`** - Error types and handling
- **`math/`** - Mathematical utilities
  - `dlmm_math.rs` - DLMM-specific calculations
  - `q64x64_math.rs` - Fixed-point arithmetic
  - `full_math.rs` - Extended precision utilities

## Constants

- `MAX_FEE_RATE: u64 = 100_000_000` (10%)
- `FEE_PRECISION: u64 = 1_000_000_000` (1e9)

## Source Code Location

All SDK source code is located in `sdk/swap-sdk/src/`.

For the most accurate and up-to-date information, always refer to the actual source files and the official SDK README.