# Best Practices

## Key Management

1. **Offline Generation**: Generate keys in a secure offline environment
2. **Secure Storage**: Use hardware wallets or encrypted storage
3. **Regular Backups**: Regularly backup encrypted private keys
4. **Access Control**: Implement strict access control policies

## Signing Practices

1. **Intent Verification**: Always verify signature intent
2. **Timestamping**: Add timestamps to signatures to prevent replay
3. **Nonce Usage**: Use nonces where appropriate
4. **Scheme Verification**: Verify signature scheme matches expectations

## Address Handling

1. **Format Validation**: Always validate address format
2. **Checksum Checking**: Check address checksums
3. **User Confirmation**: Have users confirm addresses before important operations
4. **Phishing Prevention**: Educate users to recognize phishing addresses