# Summary Templates

Formats for capturing mutual understanding. Match formality to situation.

---

## Core Principle

**Summaries confirm understanding, not create documentation.**

The goal is ensuring AI and user are aligned before proceeding. Keep it as simple as the situation allows.

---

## Standard Understanding Summary

Use for most situations:

```markdown
## Understanding Summary

**What we're doing**: [One clear statement]

**Goals**: [What success looks like]

**Key Points**:
- [Important point 1]
- [Important point 2]
- [Important point 3]

**Approach**: [How we'll proceed]

**Boundaries**: [What's NOT included]

**Open items**: [Any remaining uncertainties, or "None"]

---
Ready to proceed?
```

---

## Quick Summary

For simple, clear requests:

```markdown
**Got it**: [What user wants in one sentence]

**I'll**: [What AI will do]

**Confirm**: Ready to proceed?
```

---

## Brainstorming Summary

After exploratory conversations:

```markdown
## Where We Landed

**Exploring**: [Topic/problem space]

**Options Considered**:
1. [Option] - [Trade-off]
2. [Option] - [Trade-off]
3. [Option] - [Trade-off]

**Direction**: [What user is leaning toward]

**Next Step**: [What happens now]

**Still Open**: [Unresolved questions, if any]
```

---

## Complex Work Summary

For multi-faceted projects:

```markdown
## Understanding Summary

**Project**: [What this is]

**Goal**: [What success looks like]

### Key Elements
1. [Element 1]: [Brief description]
2. [Element 2]: [Brief description]
3. [Element 3]: [Brief description]

### Decisions Made
| Decision | Choice |
|----------|--------|
| [Decision 1] | [What we chose] |
| [Decision 2] | [What we chose] |

### Constraints
- [Constraint 1]
- [Constraint 2]

### Approach
[How we'll proceed]

### Not Included
- [Out of scope 1]
- [Out of scope 2]

### Open Items
- [Remaining question, if any]

---
Does this capture what you want?
```

---

## Decision Summary

When helping user make a choice:

```markdown
## Decision Summary

**Question**: [What we were deciding]

**Options Evaluated**:
| Option | Pros | Cons |
|--------|------|------|
| [A] | [Pros] | [Cons] |
| [B] | [Pros] | [Cons] |

**Decision**: [What user chose]

**Rationale**: [Why this choice]

**Next**: [What happens now]
```

---

## Formality Guide

| Situation | Template | Why |
|-----------|----------|-----|
| Simple request | Quick Summary | Don't over-formalize simple things |
| Brainstorming | Brainstorming Summary | Capture exploration, not specs |
| Clear medium task | Standard Summary | Right balance |
| Complex/multi-part | Complex Summary | Need more structure |
| Decision-making | Decision Summary | Document the choice |

---

## Summary Quality Check

Before presenting summary, verify:

- [ ] **Specific**: Could someone act on this?
- [ ] **Complete**: All key points captured?
- [ ] **Accurate**: Reflects what user said?
- [ ] **Scoped**: Boundaries are clear?
- [ ] **Actionable**: Clear what happens next?

If you can't make it specific, you need more questions first.
