# Table Structures

Tables discovered during implementation. Reference for future sessions.

## Main Database Tables

### SiteMessage
Location: `monika/Monika/Main/dbo/Tables/SiteMessage.sql`

| Column | Type | Notes |
|--------|------|-------|
| Id | INT IDENTITY | PK |
| WebId | INT | FK to Website |
| Type | INT | Message type |
| ReceiverType | NVARCHAR(50) | Username/Agent/Currency/Tag |
| ReceiverValue | NVARCHAR(MAX) | Target values |
| CreatedBy | NVARCHAR(50) | Audit |
| CreatedOn | DATETIME | Audit |
| ModifiedBy | NVARCHAR(50) | Audit |
| ModifiedOn | DATETIME | Audit |

### Customer
Common columns used in validation:

| Column | Type | Notes |
|--------|------|-------|
| CustomerId | INT | PK |
| WebId | INT | FK to Website |
| Username | NVARCHAR(50) | Login name |
| AccountType | INT | 1=Player, 2=Agent, 7=Admin, 8=SuperAdmin |
| AgtId | INT | Parent agent (0 for root) |

---

## Adding New Tables

When discovering table structures during implementation:

1. Read the table SQL file from Monika
2. Add structure here with columns used
3. Commit this file after code commit
