# Contributing Guide

## Commit Message Format

```
[{SkillName}] {Action} v{Major}.{Minor}.{Patch} (YYYY-MM-DD)

- Change 1
- Change 2
- Change 3
```

### Actions

| Action | When to Use | Version Bump |
|--------|-------------|--------------|
| `Init` | First commit | 1.0.0 |
| `Feature` | New feature added | Minor (x.Y.0) |
| `Fix` | Bug fix | Patch (x.y.Z) |
| `Upgrade` | Major restructure | Major (X.0.0) |
| `Refactor` | Code improvement | Patch (x.y.Z) |
| `Docs` | Documentation only | Patch (x.y.Z) |

### Examples

```bash
# Initial release
[BackofficeFullstack] Init v1.0.0 (2025-01-08)

- Initial skill creation
- Basic FE/BE/DB workflows
- Domain knowledge documentation

# New feature
[BackofficeFullstack] Feature v2.1.0 (2025-01-10)

- Added player notes CRUD feature
- Created new playbook for notes

# Bug fix
[BackofficeFullstack] Fix v2.0.1 (2025-01-09)

- Fixed apiCalling template typo
- Corrected SP versioning example

# Major upgrade
[BackofficeFullstack] Upgrade v2.0.0 (2025-01-08)

- Reorganized folder structure
- Added CustomerRecordReport pattern
- Breaking: templates moved to /templates
```

---

## Version History

| Version | Date | Description |
|---------|------|-------------|
| v1.0.0 | 2025-01-08 | Initial skill creation |
| v2.0.0 | 2025-01-08 | Structure enhancement, artemis pattern |

---

## File Naming Conventions

| Type | Convention | Example |
|------|------------|---------|
| Agent guide | `{name}-agent.md` | `kirby-fe-agent.md` |
| Template | `{layer}-{type}-template.{ext}` | `fe-composable-template.ts` |
| Playbook | `{feature}.md` | `crud-feature.md` |
| Domain doc | `{NN}-{name}.md` | `03-membership.md` |
