# Backoffice Fullstack - Quick Index

## Fast Development

### Full Feature
```
1. Load domain knowledge from docs/backoffice/
2. Database → Backend → Frontend
3. Use sub-agent guides in agents/
```

### FE Only (CustomerRecordReport Pattern)
```
Model → apiCalling.ts → apis.ts → FakeData → Composable → Component → Router
```

### BE Only
```
Model → Repository → Service → Controller → Register DI
```

### DB Only
```
Table → Stored Procedure → InsertData.sql (sp_lookup)
```

---

## Project Paths

| Project | Path |
|---------|------|
| Kirby (FE) | `/Users/rithytep_1/projects/Nuxt/kirby` |
| Coloris (BE) | `/Users/rithytep_1/projects/BackEnd/Coloris` |
| Monika (DB) | `/Users/rithytep_1/projects/BackEnd/monika` |

---

## FE Quick (Kirby)

### API Files (ONLY 2)
```
src/libraries/apiCalling.ts  → callGetFeature(request)
src/libraries/apis.ts        → getFeature(request) ← composables use this
```

### Key Patterns
```typescript
// Composable uses apis (NOT apiCalling)
import apis from '@/libraries/apis';
const { Data, ErrorCode } = await apis.getFeatureList(request);

// Dynamic columns
import { IColumnsDynamic } from '@/models/Columns';

// Error handling
if (ErrorCode === EnumApiErrorCode.Success) { ... }
notificationHelper.notification(ErrorMessageForDisplay, EnumMessageType.Error);
```

### Router Entry
```typescript
{
  path: '/feature/list',
  name: 'FeatureList',
  component: () => import('@/views/desktop/feature/FeatureList.vue'),
  beforeEnter: (to, from, next) => authorizeRoute('feature/feature_list', next, {}, 'Module'),
}
```

---

## DB Quick (Monika)

### SP Versioning
```sql
-- Format: {Service}_{Feature}_{Action}_{Major}.{Minor}.{Patch}
Coloris_Player_GetNotes_1.0.0
Promodia_GetMemberPromotion_1.2.0
```

### SP Registration (InsertData.sql)
```sql
INSERT [dbo].[SimpleSettings]
  ([Website], [IsUAT], [Type], [Id], [Value], [Decription], [PossibleValues], [Responsible], [ModifiedBy], [ModifiedOn], [IsEnabled])
VALUES
  (N'Coloris', 0, N'sp_lookup', N'Coloris_Player_GetNotes', N'[dbo].[Coloris_Player_GetNotes_1.0.0]', N'', N'', N'Developer', N'Rithy', GETDATE(), 1)
```

### Schema Locations
| Schema | Use For |
|--------|---------|
| Main | Customer, core tables |
| Promotion | Bonus, rebate, events |
| VIP | VIP levels, benefits |
| Payment | Transactions, banking |
| Record | Betting records |
| ApplicationSetting | Config, settings |

---

## Error Codes

| Code | Message | Usage |
|------|---------|-------|
| 0 | Success | All operations |
| 330 | Duplicate | Conflict on create |
| 342 | Invalid operation | Business rule violation |
| 400 | Bad request | Validation failure |
| 404 | Not found | Record not found |
| 515 | Duplicate event | Overlapping dates |

---

## Files

| Need | File |
|------|------|
| Full guide | `SKILL.md` |
| FE agent | `agents/kirby-fe-agent.md` |
| BE agent | `agents/coloris-be-agent.md` |
| DB agent | `agents/monika-db-agent.md` |
| FE templates | `templates/fe-*.ts` |
| Domain knowledge | `docs/backoffice/*.md` |
| Playbooks | `playbooks/*.md` |

---

## CLI Commands

```bash
# FE dev server (staging)
cd /Users/rithytep_1/projects/Nuxt/kirby && npm run serve:stg

# Build Coloris
cd /Users/rithytep_1/projects/BackEnd/Coloris/coloris/Coloris && dotnet build

# Test API
curl -X POST "http://localhost/api/feature/v2/get-list" \
  -H "Authorization: Bearer {token}" \
  -H "Content-Type: application/json" \
  -d '{"WebId": 1, "PageIndex": 1, "PageSize": 25}'
```
