# 1. Dashboard

**Page description:** Platform data overview. Operators can use data performance to analyze the current operating status.

---

## 1.1 Operation Overview

### Current Win/Lost and Cap Limit

The operator deposits to us (Our finance), based on the "pre-payment" amount, and the system will exchange the amount into Euro and add it to the "Cap limit".

Every month, our finance will send a bill, and the bill amount will be deducted from "pre-payment balance". The system will update the "Cap limit" based on the latest "pre-payment" amount.

#### Cap Limit
The "pre-payment" will be exchanged to Euro and converted to Cap limit.

#### Current Win/Lost
The system will only calculate the products you profit (company won), and will not deduct the amount that you lose. That means, we will only charge the commission from your positive "company win/lost" amount, and will not charge for the negative one.

**When the cap limit reaches 100%:** The player site will disable the following functions:
- Deposit and withdrawal
- Betting

Once you deposit more, the cap limit will be increased based on the pre-payment amount.

After monthly bill settlement, as a result, the Cap percentage usually decreases and all the functions work as normal.

After clicking the Cap area in the dashboard, it will redirect to the 4.10 Cap Report.

### Dashboard Metrics

- **Number of players and cash agents**
- **Main wallet, Promotion wallet, Referral wallet overview and total outstanding amount**
- **Number of people registering, depositing, withdrawing, applying for promotions, and applying for referrals**

### Data for the Past 24 Hours
- **Online users:** Players' login, bet, deposit and withdrawal behaviors will be recorded
- **Registration and first deposit count:** Operators can use this metric to view their site's player conversion rate

### Bank Balance for the Past Seven Days
| Type | Description |
|------|-------------|
| Bank transfer | The system calculates the amount of deposits and withdrawals made by players through the "5.5 Company Bank" in the backoffice |
| Payment gateway | System calculates the amount of deposits and withdrawals made by players using third party payment gateway |
| Manual transaction | The system calculates the amount of "Manual Transfer"; "manual deposit" and "manual withdrawal" |

---

## Star Icons Feature

"The Star Icon" indicates items that a user wishes to mark as important, favorite, or easily accessible.

### How to Use Star Icons
1. You can manage your favorite or important pages by marking them as starred
2. They will be saved in the "Starred" page, allowing you to access them quickly without spending time searching for them
3. If you star two pages, two stars will appear filled, and it will be saved in the "Starred" page

### Accessing Starred Pages
"Starred" page maintains a record of all pages you have starred, allowing you to quickly access them without the need to search manually.

### Removing Starred Pages
To remove a starred page, click the star icon in the "Starred" page. The page will immediately be removed from the starred list.

---

## Test Scenarios

### Cap Limit
| Scenario | Type | Expected |
|----------|------|----------|
| Cap limit calculation from pre-payment | Positive | Amount correctly exchanged to Euro |
| Cap reaches 100% | Negative | Deposit, withdrawal, betting disabled |
| Deposit after 100% cap | Positive | Cap limit increases, functions re-enabled |
| Monthly settlement | Positive | Cap percentage decreases |
| Click Cap area | Positive | Redirects to 4.10 Cap Report |

### Star Icons
| Scenario | Type | Expected |
|----------|------|----------|
| Star a page | Positive | Page saved to "Starred" list |
| Star multiple pages | Positive | All starred pages saved |
| Access starred page | Positive | Quick navigation works |
| Remove starred page | Positive | Page removed from list immediately |
