# 2. Sub-Account

**Page description:** The operator creates a sub-account and grants various operation permissions.

---

## 2.1 Sub Account List

### a. Create a Sub-Account
Operators can create sub-accounts for team members.

### b. View All Sub-Accounts
View the complete list of all created sub-accounts.

### c. Modify Sub-Account Information and Permissions

#### Status Options
| Status | Description |
|--------|-------------|
| Open | Sub-accounts can log in to the backoffice |
| Closed | Sub-accounts cannot log in to the backoffice |
| Suspend | No impact. If you check Yes or No, all sub-accounts can log in to the backoffice |

---

## 2.2 Permission Settings

### a. Sub-Account Group Permission Settings

| Permission | Description |
|------------|-------------|
| Create | Sub-accounts have permission to create |
| Read | Sub-accounts have read permission |
| Update | The sub-account has update permissions |
| Delete | The sub-account has the permission to delete |
| Export | The sub-account has the permission to export |

### b. Encrypt Members Information

After selecting the encrypt member information and Update Permission:
- The player information will be encrypted as "***"
- The sub-account in the selected group list will not be able to see the player information
- After login to the sub-account, the sub-account will see the member information encrypted as "***"

### c. Sub-Account IP Whitelist

When this feature is enabled and an IP is added:
- The sub-account group can only log in to the sub-account backend using the specified IP

---

## Test Scenarios

### Sub-Account Creation
| Scenario | Type | Expected |
|----------|------|----------|
| Create sub-account with valid data | Positive | Account created successfully |
| Create sub-account with duplicate username | Negative | Error: Username exists |
| View all sub-accounts | Positive | Complete list displayed |

### Status Management
| Scenario | Type | Expected |
|----------|------|----------|
| Set status to Open | Positive | Sub-account can login |
| Set status to Closed | Negative | Sub-account cannot login |
| Set status to Suspend | Positive | No login impact |
| Change Open to Closed | Positive | Login blocked immediately |

### Permission Settings
| Scenario | Type | Expected |
|----------|------|----------|
| Grant Create permission only | Positive | Can create, cannot read/update/delete |
| Grant Read permission only | Positive | Can view, cannot modify |
| Grant all CRUD permissions | Positive | Full access |
| Grant Export permission | Positive | Can export data |
| Remove Update permission | Positive | Cannot modify items |

### Encrypt Member Information
| Scenario | Type | Expected |
|----------|------|----------|
| Enable encryption for group | Positive | Player info shows as "***" |
| Disable encryption | Positive | Player info visible |
| Sub-account views encrypted data | Positive | Cannot see actual player info |

### IP Whitelist
| Scenario | Type | Expected |
|----------|------|----------|
| Add IP to whitelist | Positive | Only that IP can login |
| Login from whitelisted IP | Positive | Login successful |
| Login from non-whitelisted IP | Negative | Login blocked |
| Add multiple IPs to whitelist | Positive | All listed IPs can login |
| Remove IP from whitelist | Positive | That IP can no longer login |
