# 3. Membership

**Page description:** View agent account, player account information, player VIP settings, and send site messages.

### Page Overview:
- **3.1:** New Register players notification, View detailed information of players/cash agents, Edit/batch edit account's information
- **3.2:** Player balance, outstanding bets, promotion wallet information
- **3.3:** Account tag setting
- **3.5:** VIP system settings
- **3.6:** Live account list
- **3.7:** Send messages to players
- **3.8:** Action Log
- **3.9:** KYC Setting
- **3.10:** KYC Verify

---

## 3.1 Member List

### a. New Register Players Notification

We have added the notification of new registered players, so the operator can review the new registered player on the back office header. The players created by the cash agent will also trigger the notification.

**To enable:**
1. Enable the toggle "IsNotificationOfNewRegister" in back office 9.1 system parameter
2. Once enabled, you will see the notification of the New Register display on the header

**Features:**
- The operator can roughly review the new registered players when clicking the notification
- Clear the data after clicking "Mark all as read"
- The hyperlink of the username will redirect to the player profile

### User Profile

You can view the KYC level in the User profile.

#### User Profile Tabs:

| Tab | Description |
|-----|-------------|
| Basic Information | View the player account info, status, register & last login, remark, performance and balance |
| Transaction | View deposit and withdrawal on the set time range: Today, This Week, This Month, Lifetime, Custom Date |
| Bet History | View betting record of the player on the set time range and wallets. Lifetime available |
| Promotion | View the running promotion wallet and promotion application on that player. Lifetime available |
| Custom Date | Operators can manually select a specific Start Date and End Date |
| Login Log | View the login history, IP, Browser, Platform, City and Domains |
| IP / FP | Detect shared IP addresses and device fingerprints among players |
| Withdrawal Limit | View the running withdrawal limit and remaining withdrawal limit. Can be edited or force completed |

#### IP / FP Features:
- **Same IP and FP:** Display accounts that have shared the same IP and FP address
- **Same IP:** Display accounts that shared the same IP
- **Same FP:** Display accounts that shared the same device fingerprint (FP)

This feature supports:
- Risk control
- Fraud prevention
- Account behavior analysis

### b. View Player/Cash Agent Details

**Information includes:**
- Player's referral
- Upperline Agent
- Label
- Account status information
- Whether to deposit
- Name
- Player bank name
- Player bank account number
- Mobile phone
- Email
- Account creation time
- Last login time
- Registered IP
- Last logged in IP
- Registered domain

#### Search Filters

| # | Filter | Description |
|---|--------|-------------|
| 1 | Information | Search from: Last Login Time, Create Time, First Deposit Time |
| 2 | Time | Search time interval |
| 3 | Player account type | Cash version |
| 4 | Conditional search | Perform precise search |
| 5 | Tag | Search for players tagged with a specific tag |
| 6 | Status | Search: all, closed, open |
| 7 | Suspend | Search: All, Yes, No |
| 8 | Currency | Search by currency |
| 9 | Deposit or not | Search by deposit status |
| 10 | Order by | Username, create time |
| 11 | Order by dir | Ascending or descending |

#### ID Card Filter
The ID filter allows operators to view the KYC levels of all users associated with the entered ID.

#### KYC Level Filter
Filter players by KYC level in Backoffice 3.1.

### c. Edit Player Information

#### Field Descriptions:

| Field | Description |
|-------|-------------|
| Status | Open: Can enter playersite; Closed: Cannot enter. Auto-closed after 3 wrong passwords |
| Suspend | Can enter playersite but cannot bet, deposit, or withdraw |
| Lock | Currently no functionality |
| Tags | Adjust tag categories (set in 3.3 Settings) |
| Login password | Reset player's account password |
| Payment password | Reset 4-digit withdrawal password |

**Note:** Disable payment password in "9.1 System Parameter" → "IsPaymentPasswordEnable"

#### Batch Edit
Update status of multiple players at once, add or remove tags.

#### Remark Feature

**Permissions:**
- Company account: modify/delete all remarks
- Sub-account: only own remarks (with CRUD permissions)
- Disabled button style if no permission
- Pagination if more than 10 remarks

**Remark Permission Settings:**
- Search Read enable → Remark Read enable
- Search Update enable → Remark C/U/D enable

Remark info displayed during Deposit/Withdraw verification (click + sign).

#### Export Permission
Disable export for sub-account in 2.2 permission setting.

**Important:** Click "Updates Permission" after editing.

---

## 3.2 Account Balance

### a. Player Cash Balance, Outstanding Amount, Promotion Wallet Information

**Cash Balance:** Main wallet amount plus outstanding bets amount.

#### Column Descriptions:

| Column | Description |
|--------|-------------|
| Cash Balance | Wallet balance |
| Outstanding | Unsettled sports bets amount |
| Total Balance | Wallet balance + Outstanding |
| Eligible Withdrawal | Amount from promotion/referral wallet that doesn't need withdrawal limit |
| Withdraw Limit | Turnover required before withdrawal (based on WithdrawalLimitRatio in 9.1) |

### Withdrawal Limit Adjustment Logic

#### Rules:
1. **Sequential Order:** Turnover applied starting from oldest requirement to newest
2. **Completion Condition:** Stops when bet consumed OR all requirements completed

#### Example Scenarios:

**Initial Requirements:** 1st: 20, 2nd: 30, 3rd: 40 (Total: 90)

| Scenario | Bet | Result |
|----------|-----|--------|
| 1 | 90 | All three completed simultaneously |
| 2 | 50 | 1st (20) + 2nd (30) completed; 3rd (40) remains |
| 3 | 30 | 1st (20) completed; 2nd partial (10/30); 3rd (40) remains; Total remaining: 60 |
| 4 | 10 | 1st partial (10/20); 2nd (30) + 3rd (40) remain; Total remaining: 80 |
| 5 | 100 | All completed; excess turnover has no negative effect |

### b. Manual Deposit, Withdrawal, and Withdrawal Limit

Click cash balance to manually:
- Deposit
- Withdraw
- Adjust withdrawal limit

---

## 3.3 Label Settings

### a. Account Label Settings

Customize new labels and view all accounts marked under each label.

#### Important Notes:
1. Multiple tags: display color based on highest priority tag
2. Risk players and arbitrage players labels cannot be deleted
3. **Arbitrage player tag:** Automatically marked by system

### Auto Default Tags

System auto-assigns tags when player completes:
- SMS OTP verification
- Email OTP verification
- 2FA
- Bank account submission

**Note:** Default tags cannot be deleted but color and priorities can be adjusted.

### b. View Tagged Player Accounts

View all accounts associated with a specific tag.

---

## 3.5 VIP Setting

### a. VIP System Setting

Set threshold for each VIP level and rebate ratio per game provider.

#### Key Points:
- VIP upgrade bonus and rebates → Main Wallet
- VIP rebates are separate from 6. Promotions rebates (players can receive both)
- Exclude players: set "Exclude from VIP" in Player Profile

### VIP Manual Upgrade

**Steps:**
1. Search username
2. Click "Edit"
3. Select VIP level, click "Save"

#### Manual Upgrade Rules:
- NO upgrade bonus for manual upgrades
- Bonus only when player fulfills requirements naturally
- Turnover restarts from zero after manual upgrade
- If manually upgraded then downgraded, player CAN get bonus when naturally re-upgrading
- Manual upgrade/downgrade available
- Check records in 3.5.1 VIP Level Record

### Rebate Settings

| Setting | Description |
|---------|-------------|
| Rebate Interval | Daily/Weekly/Monthly (system timezone) |
| Rebate Calculation | Based on net turnover from Main/Promotion/Referral wallet |
| Rebate Withdrawal Limit Ratio | Set in 9.1 "RebateWithdrawalLimitRatio" |

### Level Setting

- **9 levels total**
- Customizable level names
- Minimum 2 consecutive levels must be enabled
- Default level: Carbon
- Can skip levels if requirements met (get multiple bonuses)
- Upgrade at 12:05AM backoffice timezone

### Level Requirement

#### Upgrade/Downgrade (Maintain Level)

| Field | Description |
|-------|-------------|
| Membership Renewal | permanent, 30, 90, 365 days |
| Maintain Level Accumulated Deposit | Deposit to retain level |
| Maintain Level Accumulated Turnover | Turnover to retain level |

#### Upgrade

| Field | Description |
|-------|-------------|
| Upgrade Level Minimum Deposit | Deposit to upgrade |
| Upgrade Level Minimum Turnover | Turnover to upgrade |

#### Setup Notes:
- If one requirement = 0, only other requirement needed
- If both > 0, both must be met
- Value cannot be ≤ previous level

### Benefits Setting

#### VIP Upgrade Bonus
One-time bonus on upgrade. No re-issue if downgraded and upgraded again.

#### Max Rebate Amount

| Setting | Description |
|---------|-------------|
| 0 (Default) | No limit - full rebate issued |
| Number | Maximum rebate cap per level |

**Example (Max = 388 for VIP3):**
- Player due 200 → Receives 200
- Player due 500 → Receives 388

#### VIP Rebate Types

| Type | Description |
|------|-------------|
| Sports rebate | Sports products |
| Virtual sports rebate | Virtual sports |
| Live rebate | Live games |
| Game rebate | Games (excluding fishing) |
| Cockfighting rebate | Cockfighting |
| Chess and card rebate | Chess/cards |
| Lottery rebate | Lottery |

### VIP Auto Message

System sends congratulation message on level upgrade. Player can view current level and achievement.

---

## 3.5.1 VIP Level Record

**Information displayed:**
- Upgrade/Downgrade
- Original Level → New Level
- Date of VIP change
- Modified By
- Upgrade Bonus

Records available for past 7 days.

---

## 3.5.2 VIP Reward Report

Track VIP upgrade bonuses and rewards.

**Features:**
- Filter by date, type, currency, username
- Summary of total rewards by currency/type
- Detailed list of individual rewards

---

## 3.7 Message

### Message Categories:
- Announcement
- Notification
- Promotion
- Personal message

### Message Sending Objects:

| Object | Description |
|--------|-------------|
| All | All players |
| Specify Username | Specific players (multiple allowed) |
| Specify Agent Downline | All players under specific agents |
| Specify Currency Member | All players of specified currency |
| Specify Tag | Players with specific tag |

---

## 3.8 Action Log

### Action Types Recorded:
- Approved/Reject Deposit
- Approved/Reject Withdrawal
- Approved/Reject Promotion
- Manual Transfer
- Change Password
- Change Member Status
- Change Account Information
- Change Bank Account Info
- Change Promotion Setting
- Create Promotion
- Change VIP Setting
- Stage One/Two Approved
- Change Currency Threshold
- Apply Recommended Settings

---

## 3.9 KYC Setting

**Page Description:** Configure player verification process by currency.

### Configuration Options:
- Verification Method Requirements
- Player Feature Management (restrict/grant deposit, withdrawal)
- KYC Level Completion Reward

### Activation Steps:
1. Select "Edit"
2. Click "Active" in status field
3. Set KYC requirement per currency

### Default Verification Methods:
- Phone OTP
- Email OTP
- 2FA
- Personal Information

### KYC Levels (3 levels)

| Level | Example Config |
|-------|----------------|
| Level 1 | Phone Number → Enable Deposit → Reward: 10 |
| Level 2 | Email OTP → Enable Withdrawal → Reward: 20 |
| Level 3 | Personal Info → None → Reward: 30 |

### One-Time Reward
- Transferred to Main Wallet
- KycWithdrawalLimitRatio applied (set in 9.1)
- Enter 0 for no bonus

---

## 3.10 KYC Verify

**Page Description:** Verify/approve player KYC submissions.

### Status Flow:

| Status | Description |
|--------|-------------|
| Waiting | Player submitted, pending operator review |
| Approved | Verification passed, player sees level achievement |
| Rejected | Wrong info/document, player can "Re-Verify" |

---

## Test Scenarios

### Member List
| Scenario | Type | Expected |
|----------|------|----------|
| New registration notification | Positive | Notification shown on header |
| Mark all as read | Positive | Notifications cleared |
| Username hyperlink | Positive | Redirects to player profile |
| Search by Last Login Time | Positive | Correct results |
| Search by KYC Level | Positive | Filtered by level |
| Filter by ID Card | Positive | Shows all users with that ID |

### Account Status
| Scenario | Type | Expected |
|----------|------|----------|
| Set status Open | Positive | Player can access playersite |
| Set status Closed | Negative | Player cannot access |
| 3 wrong passwords | Negative | Account auto-closed |
| Suspend account | Positive | Can access but cannot bet/deposit/withdraw |
| Batch edit status | Positive | Multiple players updated |

### Withdrawal Limit
| Scenario | Type | Expected |
|----------|------|----------|
| Bet completes oldest requirement first | Positive | Sequential order |
| Bet completes multiple requirements | Positive | All applicable completed |
| Bet exceeds total limit | Positive | No negative effect |
| Manual force complete | Positive | Limit cleared |

### VIP System
| Scenario | Type | Expected |
|----------|------|----------|
| Meet upgrade requirements | Positive | Upgraded at 12:05AM |
| Skip level (meet higher requirements) | Positive | Skip + multiple bonuses |
| Manual upgrade | Positive | No bonus issued |
| Manual upgrade then natural re-upgrade | Positive | Bonus issued |
| Downgrade (requirements not met) | Negative | Level reduced |
| Max rebate cap applied | Positive | Rebate capped at max |

### KYC
| Scenario | Type | Expected |
|----------|------|----------|
| Complete Level 1 KYC | Positive | Deposit enabled, reward issued |
| Complete Level 2 KYC | Positive | Withdrawal enabled, reward issued |
| KYC rejected | Negative | Player can re-verify |
| KYC reward = 0 | Positive | No bonus, feature enabled |
