# 4. Reports

**Page description:** Product performance, bet inquiry, player performance, daily site performance.

### Section Overview:
- **4.1:** View players win and lose from a product perspective
- **4.1.1:** View player wins and losses from a product perspective (Revenue Statement)
- **4.2:** Player betting records
- **4.3:** Player sports betting records
- **4.4:** Provider Win/Lost
- **4.5:** View win and lost performance from the player's perspective
- **4.6:** All account information (Player Summary)
- **4.8:** Daily performance of the site
- **4.10:** View the Cap Report
- **4.11:** View the Sport Match Report

---

## 4.1 Win/Lost

### a. View Player Win/Lost from a Product Perspective

View the performance of each product. After clicking the player's name, you will see the bet details.

**Features:**
- View the performance of all products within the time range
- View a single player's performance across all products within a time range
- **Search time:** Search data for up to two months (including the current month)

---

## 4.1.1 Revenue Statement

### a. View Player Win/Lost from a Product Perspective

View the performance of each product, and see which players have played under each product. Unlike the 4.1 page, the search time can be earlier, but you cannot view the details of players' bets.

**Features:**
- View the performance of all products on the site within a specified time range
- View the performance of all products for a single player within the specified time range
- View the Average (Stake Per Bet & Bet Count Per AU) within the specific time range

### Add Filter by Game

View the performance of specific games under specific providers.

**Steps:**
1. Search the game provider first
2. Select the game in the game filter

---

## 4.2 Betting Records

### a. Player Betting Records

Query all betting records and Ref NO of a player. Supports: Sports, Live Casino, Games, Virtual Sports, Lottery, Cockfight, and Poker.

**Important Notes:**
- Records kept within **two months**
- Single search cannot exceed **7 days**
- Bole Gaming chess "Ref NO" saved only for **7 days**

**Search Filters:**
| # | Filter | Description |
|---|--------|-------------|
| 1 | Data type | Win/Lost Date, Order Time |
| 2 | Time | Search time range |
| 3 | Game category | Select category |
| 4 | Game provider | Select provider |
| 5 | Game Type | Select type |
| 6 | Username | Optional (blank = all bets) |

---

## 4.3 Sports Betting Records

### a. Player Sports Betting Records

Query betting records of all sports bets (including third-party sports).

**Query Status Options:**
| Status | Description |
|--------|-------------|
| All | All bets |
| Won | Winning bets |
| Lose | Losing bets |
| Draw | Draw results |
| Running | Unsettled bets |
| Void | Voided bets |

**Search Filters:**
| # | Filter | Description |
|---|--------|-------------|
| 1 | Data type | Win/Lost Date, Order Time, Settle Time |
| 2 | Time | Search time range |
| 3 | Provider | Sports provider |
| 4 | Status | Bet status |
| 5 | Username | Optional (blank = all bets) |

---

## 4.4 Provider Win/Lost

### a. Product Performance

View performance of a specific product or single player over a specified period.

**Time Intervals:**
| Interval | Maximum Period |
|----------|----------------|
| Daily | Up to 60 days |
| Weekly | Up to 52 weeks |
| Monthly | Up to 24 months |

**Display Layout:**
- Left: Turnover, Bet count
- Right: Win/Lost, Active users

---

## 4.5 Players Win/Lost

### a. Player Performance

**Data Fields:**
| Field | Description |
|-------|-------------|
| Currency | Player's currency |
| Current Balance | Main wallet balance |
| Deposit Count | Deposits + manual deposits + third-party deposits |
| Deposit Amount | Total deposit amount |
| Withdrawal Count | Withdrawals + manual + third-party |
| Withdrawal Amount | Total withdrawal amount |
| Bet Count | Total number of bets |
| Turnover | Total turnover amount |
| Net Turnover | Net turnover amount |
| Members Win/Lost | Player's win/lost |
| Referral Bonus | Referral bonus amount |
| Promotional Bonus | Promotion rebate amount |
| VIP Rebate | VIP rebate amount |
| VIP Bonus | VIP bonus amount |
| Manual Bonus | Manual bonus (excludes manual rebate) |
| Company Win/Lost | Company's win/lost |

---

## 4.6 Player Summary

### a. All Account Information

**Features:**
1. View all player accounts
2. Check which cash agent the player belongs to
3. Check how many players are under a certain cash agent
4. View volume performance of cash agent (registrations, first deposits)

**Note:** Rear fields show player's lifetime totals.

**Search Filters:**
| # | Filter | Description |
|---|--------|-------------|
| 1 | Statistical date | Last Login, Registration, First Deposit, Last Deposit Time |
| 2 | Time | All, today, yesterday, past 7 days, etc. |
| 3 | Account | Account number, under company, agent name, domain |
| 4 | Currency | Filter by currency |
| 5 | Amount filter | Deposit count/amount, withdrawal count/amount, balance, bonus, company W/L |
| 6 | Min/Max amount | Amount range filter |

---

## 4.8 Daily Report

### a. Daily Performance of the Site

Shows site performance every day within time interval.

---

## 4.10 Cap Report

**Page description:** Details on company win by Game provider and currency converted to Euro toward cap.

**Key Points:**
- Cap calculated only for providers with **positive** Win/Lost
- Exchange rate: average of last 30 days from xe.com (first day of month)
- Cap excludes Commission, Bonus, or Rebate

**Count Toward CAP:**
| Value | Description |
|-------|-------------|
| Y | Positive company win/lost → calculated to Cap |
| N | Negative company win/lost → NOT calculated |

---

## 4.11 Sport Match Report

**Description:** View detailed bets placed on sports matches over a date/time range.

**Note:** Virtual sport bet data NOT included.

**Data Available:**
- Sport Type
- League
- Match
- Kickoff Time
- First Bet Refno / Order Time
- Last Bet Refno
- Result Proceed Time
- No More Bet Time

---

## Test Scenarios

### Win/Lost Reports
| Scenario | Type | Expected |
|----------|------|----------|
| Search within 2 months | Positive | Data displayed |
| Search exceeding 2 months | Negative | Error or no data |
| Click player name | Positive | Bet details shown |
| Filter by game provider | Positive | Filtered results |

### Betting Records
| Scenario | Type | Expected |
|----------|------|----------|
| Search within 7 days | Positive | Records displayed |
| Search exceeding 7 days | Negative | Error message |
| Filter by game category | Positive | Filtered results |
| Search by Ref NO | Positive | Specific bet found |

### Sports Betting
| Scenario | Type | Expected |
|----------|------|----------|
| Filter by Won status | Positive | Only winning bets |
| Filter by Running status | Positive | Unsettled bets |
| Filter by Void status | Positive | Voided bets |

### Cap Report
| Scenario | Type | Expected |
|----------|------|----------|
| Provider with positive W/L | Positive | Counted toward cap (Y) |
| Provider with negative W/L | Positive | Not counted (N) |
| View by currency | Positive | Correct conversion to Euro |
