# 5. Financial Center (Transaction)

**Page description:** Review player deposit and withdrawal requests, customer bank settings, and third-party payment settings.

### Section Overview:
- **5.1:** Player deposit requirements (Deposit Verify)
- **5.2:** Player withdrawal requirements (Withdrawal Review)
- **5.3:** Platform/Player deposit and withdrawal records, TXN NO
- **5.3.1:** Payment Transaction (third-party)
- **5.4:** Player balance record (Balance History)
- **5.5:** Company Bank settings
- **5.6:** Player Bank settings
- **5.7:** Player bank grouping
- **5.8:** Third-party payment settings
- **5.9:** Manual third-party payment operations
- **5.10:** Deposit Options
- **5.11:** Payment API Info

---

## 5.1 Deposit Verify

### a. Player Deposit Requirements Approval

#### Status Flow:

| Status | Description | Operator Actions |
|--------|-------------|------------------|
| Waiting | Player submitted deposit request | Verify/Reject; Adjust deposit amount |
| Verified | Info confirmed, pending final approval | Approve/Reject; Adjust withdrawal limit |
| Approved | Completed deposits | View records by time range |
| Rejected | Denied deposits | View records by time range |
| Canceled | Player canceled on playersite | View canceled requests |
| Payment Processing | Third-party gateway in progress | View records |
| Payment Error | Third-party gateway errors | View error records |
| Manual | Manual deposit records | View manual deposits |

---

## 5.2 Withdrawal Review

### a. Player Withdrawals Require Approval

#### Status Flow:

| Status | Description |
|--------|-------------|
| Waiting | Player submitted request, needs verification |
| Verified | Info confirmed, pending approval |
| Approved | Completed withdrawals |
| Rejected | Denied withdrawals |
| Cancelled | Player canceled on playersite |
| Payment Processing | Third-party gateway in progress |
| Payment Error | Third-party gateway errors |
| Manual | Manual withdrawal records |

### Payment Provider Withdrawal Auto Approve Setting

**Note:** Auto approval only works for **payment gateway**, NOT Bank Transfer.

**Setup Steps:**
1. Select the currency (setting is per currency)
2. Enable the "Is Enable" toggle

#### Configuration Options:

| Setting | Description |
|---------|-------------|
| Max Amount for Auto Approval | Max single withdrawal amount for auto-approval. Higher amounts require manual review |
| Daily Auto Approval Count Limit | Max auto-approved transactions per 24 hours. Exceeding requires manual approval |
| Daily Auto Approval Amount Limit | Total auto-approved amount per 24 hours. Exceeding requires manual approval |
| Participation Criteria | Filter by Player Tag, VIP Level, Cash Agent |

**Notes:**
- Warning message before Submit
- Auto-approved transactions show **'System'** in Modified By field
- If conditions not met → manual approval required with remark

---

## 5.3 Transaction Record

### Transaction Types:
- All
- Deposit
- Payment Gateway Deposit
- Manual Deposit
- Withdrawal
- Payment Gateway Withdrawal
- Manual Withdrawal
- Inject Bonus (BO 6.7)
- Manual Bonus
- Manual Rebate
- Manual Balance Addition
- Manual Balance Deduction

If no username entered, searches all site transactions within time range.

---

## 5.3.1 Payment Transaction

Third-party payment transaction records. Similar to 5.3 but specifically for payment gateway transactions.

**Note:** Contact account manager for third-party payment gateway setup.

---

## 5.4 Balance History

### a. Player Balance Record

View account transaction records, cash balance changes, and unsettled bet amounts.

**Transaction Types:** Same as 5.3

**Hidden Columns by Default:**
- Currency
- Before Cash Balance
- Cash Balance Delta
- After Cash Balance
- Before Outstanding
- Outstanding Delta
- After Outstanding

**Wallet ID:** Used to identify different promotion wallets with same name.

---

## 5.5 Company Bank

### a. Add New Bank
### b. Bank Information and Status Modification

**Features:**
- Set up bank account details, logo, and QR code
- **Balance:** Tracks deposits/withdrawals (not synced with real bank)
- Set company bank by domains
- Upload Bank QR Code

### c. Crypto Currency Transfer

- Set up crypto wallet (currently **USDT only**)
- Set USDT exchange rate in 9.2 for automatic currency conversion

---

## 5.6 Player Bank

### a. Set Up Bank for Player Deposits and Withdrawals
### b. Bank Information and Status Modification

**Note:** System binds player's bank on successful deposit.

### c. Minimum and Maximum Withdrawal Amount Settings

Set min/max withdrawal amounts per bank.

**Important:** If both 9.2 Currency and 5.6 Player Bank have settings:
- Minimum withdrawal = **MAX** of both values
- Maximum withdrawal = **MIN** of both values

**Example:**

| Setting | Minimum | Maximum |
|---------|---------|---------|
| 5.6 Player Bank | 100 | 5,000 |
| 9.2 Currency | 50 | 4,500 |
| **Final Result** | **100** | **4,500** |

---

## 5.7 Player Bank Group

### a. Player Bank Grouping

Players see only banks from their assigned group (from 5.5 Company Bank).

---

## 5.8 Payment Bank Setting

Third-party payment settings. Contact account manager for setup.

---

## 5.9 Manual Payment Transaction

Manual third-party payment operations. Contact account manager for setup.

---

## 5.10 Deposit Option

### a. Deposit Amount Options

Set up to **18 deposit amount options** for player selection on deposit page.

### b. Deposit Promotion Option

Enable promotion offers on deposit page.

**Remarks:**
- Players see promotion option on deposit page
- On successful deposit approval, system auto-applies promotion
- Failed promotion → check 6.4 Promotion Application Record
- Promotions with "Need Player Apply => No" **cannot** be added

**Eligible Deposit Bonuses:**
- Deposit Bonus
- Daily Deposit Bonus
- First Deposit Bonus

**Process After Player Selects Promotion:**
1. Operator approves deposit (5.1 Deposit Verify)
2. Operator approves promotion bonus (6.3 Application Verified)
3. Deposit amount + bonus → Promotion Wallet

---

## 5.11 Payment API Info

Setup payment provider API information.

**Steps:**
1. Click 'New'
2. Fill in the information (from payment provider's backoffice)
3. Click 'Save'
4. Set for each currency

---

## Test Scenarios

### Deposit Verify
| Scenario | Type | Expected |
|----------|------|----------|
| Player submits deposit | Positive | Request in Waiting |
| Operator verifies deposit | Positive | Moves to Verified |
| Operator approves deposit | Positive | Moves to Approved, balance updated |
| Operator rejects deposit | Negative | Moves to Rejected |
| Player cancels deposit | Positive | Moves to Canceled |
| Adjust deposit amount in Waiting | Positive | Amount updated |
| Adjust withdrawal limit in Verified | Positive | Limit updated |

### Withdrawal Review
| Scenario | Type | Expected |
|----------|------|----------|
| Player submits withdrawal | Positive | Request in Waiting |
| Auto-approval within limits | Positive | Auto-approved, shows 'System' |
| Auto-approval exceeds max amount | Negative | Requires manual approval |
| Auto-approval exceeds daily count | Negative | Requires manual approval |
| Auto-approval exceeds daily amount | Negative | Requires manual approval |
| Bank Transfer (not auto-approved) | Positive | Always requires manual |

### Bank Settings
| Scenario | Type | Expected |
|----------|------|----------|
| Add company bank | Positive | Bank available for players |
| Set bank by domain | Positive | Only shows on selected domains |
| Player bank group assignment | Positive | Player sees only group banks |
| Min/Max from both 5.6 and 9.2 | Positive | Uses MAX min, MIN max |

### Deposit Options
| Scenario | Type | Expected |
|----------|------|----------|
| Set deposit amount options | Positive | Options shown on deposit page |
| Enable deposit promotion | Positive | Promotion shown on deposit page |
| Select promotion on deposit | Positive | Auto-applied after approval |
| Promotion fails to apply | Negative | Reason in 6.4 Application Record |
