# 6. Promotions

**Page description:** Settings for bonus promotion and rebate promotion, application verify, application records, promotion statistics, and manual inject bonus.

### Section Overview:
- **6.1:** Creation of promotions
- **6.2:** Promotion List, Status modification
- **6.3:** Application Verified (approval)
- **6.4:** Application records
- **6.5:** Promotion statistics
- **6.6:** Player commission settings
- **6.7:** Manual inject bonus

---

## 6.1 Create Promotion

### Promotion Types

| Type | Description | Wallet |
|------|-------------|--------|
| Bonus | Deposit + bonus → Promotion Wallet. Turnover on selected providers | Promotion Wallet |
| Rebate | Rebate → Main Wallet directly | Main Wallet |
| Reward | Promo code redemption → Promotion Wallet | Promotion Wallet |

### Promotion Wallet Closure Conditions

Wallet closes when ANY condition met:
1. Turnover reached
2. Balance = 0
3. Balance < Auto Complete Amount

---

## Bonus Promotion Types

### Register Bonus
- Fixed amount to Promotion Wallet on registration
- One-time per account (system auto-rejects duplicate)
- Risk Prevention Criteria:
  - Same login IP
  - Same phone number
  - Same email address
  - Same bank account number

### First Deposit Bonus
- First-time depositors only
- One-time per account
- Fixed amount OR percentage of first deposit
- **Minimum deposit:** Must reach limit in single deposit (not cumulative)

### Daily Deposit Bonus
- Once per day per account
- Fixed amount OR percentage
- Calculation basis: First deposit of day OR Latest deposit of day
- Minimum deposit requirement applies

### Deposit Bonus
- No time/sequence restrictions
- One deposit = one application
- Fixed amount OR percentage
- Minimum deposit requirement applies

### Lucky Wheel / Lucky Draw
- Players use tickets to win bonuses → Promotion Wallet
- Tickets do NOT support cross-event usage
- Can create both simultaneously

#### General Settings
- Home page entrance: Yes = displayed on home

#### Spin Qualification Settings
Tickets issued based on:
1. New Registered Players
2. Daily Login
3. Daily Total Turnover Amount
4. Daily Total Deposit Amount

#### Bonus Settings
- 10 bonus slots on wheel
- Set probability and max claims per bonus
- **Total probability must = 100%**

---

## Rebate Promotion Types

### Rebate On Turnover
- Based on net turnover (excluding draw/canceled bets)
- Fixed amount OR percentage
- Period: Daily/Weekly/Monthly
- → Main Wallet directly

### Rebate On Turnover Lose Only
- Based on lost bets turnover only
- Fixed amount OR percentage
- → Main Wallet directly

### Rebate On Win/Lost
- Based on player's total Win/Lost
- **Only distributed if Win/Lost is negative**
- Formula: Win/Lost × rebate ratio = Bonus

#### Exclude Rebates from W/L
| Mode | Calculation |
|------|-------------|
| Off | Normal W/L |
| On | Real W/L = Player W/L - Previous rebates |

**Example:**
| Player W/L | Previous Rebate | Rebate % | Mode | Calculate | Payout |
|------------|-----------------|----------|------|-----------|--------|
| -1000 | 300 | 5% | Off | -1000 | 50 |
| -1000 | 300 | 5% | On | -700 | 35 |

**Note:** Only available for Rebate On Win/Lost.

### Rebate On Deposit And Withdrawal
- Formula: (Total deposits - Total withdrawals) × rebate %
- Includes: Bank transfer, third-party, manual
- → Main Wallet directly

---

## Reward Promotion Types

### Coupon Reward
- Promo code redemption for bonuses or tickets
- Multiple currencies supported
- No Remark/Content/Banner (not displayed on playersite)

### Coupon Types

#### Reusable Coupon
- Multiple players can redeem (once each)
- Code rules: Alphanumeric, uppercase, max 12 chars
- Set redeemable times limit

#### One-time Coupon
| Setting | Description |
|---------|-------------|
| Number Of Coupons | System auto-generates codes |
| Maximum Per Account Usage | Limit per player |
| Maximum Total Usage | Total redemption limit |

### Error Messages

| Error | Cause |
|-------|-------|
| Expired | Event expired; Criteria not met; Application limit exceeded |
| Sold out | Max usage reached; Linked event closed |
| Invalid | Wrong code |

---

## Promotion Field Descriptions

### Language
- Set "default" first, then add languages
- Players see language-matched content or default

### Promotion Code
- Internal tracking reference

### Create Promotion by Domains
- Display promotion on selected domains only

### Is Create Promotion Wallet
| Setting | Behavior |
|---------|----------|
| Off | Bonus → Main Wallet. Must meet turnover before withdrawal |
| On | Bonus → Promotion Wallet. Transferred to Main Wallet after turnover |

**Note:** Cannot be edited after creation.

### Promotion Status

| Status | Description |
|--------|-------------|
| Active | Players can apply/receive |
| Disable | Hidden, cannot apply |
| Deleted | Removed from both sites |
| Display | Visible but cannot apply (only with "Need Player Apply" = Yes) |

### Eligible Game Providers
- Turnover only calculated on selected providers
- Shows currency-supported providers only

### Calculate Method
- Fixed amount OR Percentage

### Reward Condition

#### One Layer
Same bonus/rebate for all eligible players

#### Multiple Layer
Different rates by criteria (2-10 layers)

| Promotion Type | Criteria Options |
|----------------|------------------|
| Deposit Promotion | VIP Level, Deposit Amount, KYC Level |
| Rebate on Turnover | VIP Level, Turnover, KYC Level |
| Rebate on Turnover (Lose Only) | VIP Level, Lose Turnover, KYC Level |
| Rebate on Win/Lose | VIP Level, Win/Lose, KYC Level |
| Rebate on Deposit & Withdrawal | VIP Level, Deposit - Withdrawal, KYC Level |

### Max Ticket Count Per Interval
- Control max tickets per period
- Options: No limit, daily, weekly, monthly
- For Lucky Wheel/Draw only

### Maximum Promotion Amount
- Max amount transferred to Main Wallet on completion
- Excess amount canceled by system

### Turnover Times
- Required turnover multiplier on Eligible Game Providers

### Need Operator Verify
| Setting | Behavior |
|---------|----------|
| Yes | Manual approval required |
| No | Auto-approved by system |

### Need Player Apply
| Setting | Behavior |
|---------|----------|
| Yes | Player must apply manually |
| No | System auto-sends bonus |

### Application Deadline
- Days to apply after meeting conditions

### Include Manual Deposit
- Yes = Manual deposits count toward promotion

### Withdrawal Limit Ratio
- Formula: Rebate bonus × ratio = added withdrawal limit

### Automatic Complete Amount
- Wallet auto-completes when balance < this amount

### Participation Criteria
- Include/exclude specific players

### Application Limitation
- Reject if same info as previous applicant

### Arbitrage Player Check
- System checks for arbitrage behavior

### Total Budget For This Promotion
- Stop issuing when budget reached

---

## 6.2 Promotion List

- Promotion ID auto-generated
- Edit established promotions (gray = non-editable)
- Ticket/Coupon redirect button → 6.4 Application Record

---

## 6.3 Application Verified

### Search Options:
- Username, Agent name, Promotion type, Promotion code, Apply IP, Wallet ID

### Status Flow:

| Status | Description |
|--------|-------------|
| Waiting | Player applied, pending operator approval |
| Approved | Approved, shows current turnover progress |
| Rejected | Denied by operator |
| Completed | Promotion wallet completed |
| Promotion Transfer | Manual transfer/end wallet/view betting records |

---

## 6.4 Application Record

### Application Successful
- Promotion amount, turnover requirements, current flow

### Application Failed
- Rejection reasons displayed

### Ticket Given/Usage
- Status: Used, Unused, Expired

### Coupon Code Given/Usage
- Status: Used, Unused, Expired

---

## 6.5 Promotion Statistics

- Total Unique Players
- Total Request
- Total Request Approved
- Total Request Rejected

---

## 6.6 Commission

Player commission by currency and product type.
**Note:** Commission given per bet placed.

---

## 6.7 Manual Inject Bonus

- Batch import bonuses to multiple players
- Immediate OR scheduled upload
- Time based on backoffice timezone

---

## Test Scenarios

### Bonus Promotions
| Scenario | Type | Expected |
|----------|------|----------|
| Apply register bonus once | Positive | Bonus to Promotion Wallet |
| Apply register bonus twice | Negative | Auto-rejected |
| Apply with same IP as previous | Negative | Rejected (risk control) |
| First deposit bonus | Positive | Bonus based on deposit |
| First deposit below minimum | Negative | Not eligible |
| Daily deposit bonus | Positive | Once per day |
| Second daily deposit bonus | Negative | Rejected |

### Rebate Promotions
| Scenario | Type | Expected |
|----------|------|----------|
| Rebate on positive W/L | Negative | No rebate (not distributed) |
| Rebate on negative W/L | Positive | Rebate calculated |
| Exclude Rebates ON | Positive | Real W/L calculation |
| Exclude Rebates OFF | Positive | Normal W/L calculation |

### Coupon
| Scenario | Type | Expected |
|----------|------|----------|
| Valid coupon code | Positive | Redeemed successfully |
| Invalid coupon code | Negative | "Invalid" message |
| Expired coupon | Negative | "Expired" message |
| Max usage reached | Negative | "Sold out" message |

### Promotion Wallet
| Scenario | Type | Expected |
|----------|------|----------|
| Turnover reached | Positive | Wallet completed, balance → Main |
| Balance = 0 | Positive | Wallet auto-completed |
| Balance < Auto Complete | Positive | Wallet auto-completed |
| Exceed max promotion amount | Positive | Only max transferred, rest canceled |
