# 7. Referral (Recommend)

**Page description:** Increase player count through referral bonuses for players who refer others.

### Terminology:
- **Referrer:** Player who recommends the platform to others
- **Referee:** Players recommended by others

### Section Overview:
- **7.1:** Referral creation, list, settings
- **7.2:** Referral Bonus Review (verify)
- **7.3:** Player referral application records
- **7.4:** Referral effectiveness statistics

---

## Referral Process Flow

1. New player (referee) registers with referral code
2. Referee meets requirements → becomes effective referral
3. Referrer clicks "Redeem" → request to 7.2 Referral Verify
4. Operator approves/rejects
5. Referrer reaches turnover → wallet completed
6. Balance transferred to Main Wallet

---

## 7.1 Referral List

### Basic Settings
- Referral period
- Currency
- Status

### Effective Referee Settings

| Setting | Description |
|---------|-------------|
| Deposit amount | Minimum deposit referee must reach |
| Including manual deposit | Include operator manual deposits |
| Turnover amount | Minimum turnover for effective referral |

### Referral Bonus Settings

| Setting | Description |
|---------|-------------|
| Referral Bonus | Bonus per effective referral |
| Turnover Rollover Times | Multiplier for withdrawal requirement |
| Eligible game providers | Providers where turnover counts |

### Arbitrage Player Checking
- System auto-filters suspected arbitrage players

---

## 7.2 Referral Bonus Review

### Status Flow:

| Status | Description |
|--------|-------------|
| Waiting | Referrer clicked "Redeem", pending approval |
| Approved | Shows "Min Turnover to Withdraw" |
| Rejected | Effective referrals remain, can re-click "Redeem" |
| Completed | Referral wallet completed |
| Referral Transfer | Transfer balance, end wallet, view records |

---

## 7.3 Referral Record

- Total referrals count
- Effective referral count
- Click effective count → see referee list

---

## 7.4 Referral Statistics

- Apply count
- Approved count
- Completed count
- Total deposit
- Total bonus

---

## Test Scenarios

### Referral Process
| Scenario | Type | Expected |
|----------|------|----------|
| Register with valid referral code | Positive | Code accepted |
| Register with invalid code | Negative | Error message |
| Referee meets requirements | Positive | Becomes effective referral |
| Referee below deposit minimum | Negative | Not effective |
| Referrer redeems bonus | Positive | Request in Waiting |
| Approve referral bonus | Positive | To Approved, wallet created |
| Reject referral bonus | Negative | Referrals remain, can re-redeem |
| Complete turnover requirement | Positive | Wallet completed, to Main |
