# 8. Game Platform (Game & Provider)

**Page description:** Adjust game providers and games, bet limits, display settings.

### Section Overview:
- **8.1:** Provider List - switches, labels, order
- **8.2:** Game List - game switches, special selection
- **8.3:** Betting Limit Settings
- **8.3.1:** Player Limit Setting
- **8.3.4:** 3rd Party Game Bet Setting
- **8.4:** SBO Sports Type Sorting
- **8.5:** Promoted League

---

## 8.1 Provider List

### a. Game Provider Switch
- Enable/disable providers
- "Hot" and "New" labels

### b. Popular and New Game Settings
Set which games appear as "Popular" or "New".

### c. Currency Support
View which currencies each provider supports.

### d. Game Category Order
Adjust display order in "Games" lobby:
- All Games, Special Selection, Hot Games, New Games
- Favorite, Game Type, Provider

### e. Game Provider Display Order
- SBO/568Win display first by default (cannot adjust)
- Enabled = green text, Disabled = red text
- Drag to adjust order

### Product Type Order
- Mobile version only
- Managed separately from Desktop Menu

---

## 8.2 Game List

### a. Game Switch
Enable/disable individual games.

### Special Selection
- Choose games to display in "Games" category
- Up to 100 games
- If unused, not displayed on playersite

### RTP (Return to Player)
- View RTP per game
- Filter by RTP range
- **Values are fixed, cannot edit**

### Hot Game List
- Up to 100 games
- Displayed in "Hot Games" section

---

## 8.3 Betting Limit Settings

### Sports Bet Limits
| Setting | Description |
|---------|-------------|
| Min Bet | Minimum bet per ticket |
| Max Bet Per Match | Maximum per match |
| Max Parlay Payout | Maximum parlay payout |
| Max Bet Per Ticket | Maximum per ticket |

### Casino Bet Limits
| Setting | Description |
|---------|-------------|
| Casino Min Bet | Minimum per bet |
| Casino Max Bet | Maximum per bet (includes 3rd party) |
| SBO Casino Table Limit | Table minimum |

---

## 8.3.1 Player Limit Setting

Adjust bet limits for individual players.

**Conflict Resolution (when 8.3, 8.3.1, 8.3.4 all set):**
- Minimum bet = **MAX** of all minimums
- Maximum bet = **MIN** of all maximums

---

## 8.3.4 3rd Party Game Bet Setting

Not all third-party providers support this.

Same conflict resolution as 8.3.1.

---

## 8.4 SBO Sports Type Sorting

Reorder SBO sports types for regional popularity.

**Notes:**
- SBO Sports Global only
- My Favorites stays at top
- Changes apply to Popular tab only
- Live events listed above non-live

---

## 8.5 Promoted League

Promote popular league events to top.

**Notes:**
- SBO Sports Global only
- Live/Early Market displayed above Non-Live
- One promoted league per sport type

---

## Test Scenarios

### Provider Management
| Scenario | Type | Expected |
|----------|------|----------|
| Enable provider | Positive | Games available |
| Disable provider | Negative | Games unavailable |
| Set "Hot" label | Positive | Label displayed |
| Reorder providers | Positive | New order on playersite |

### Game Management
| Scenario | Type | Expected |
|----------|------|----------|
| Enable game | Positive | Game playable |
| Disable game | Negative | Game unavailable |
| Add to Special Selection | Positive | Game in category |
| Add to Hot Games | Positive | Game in Hot section |

### Bet Limits
| Scenario | Type | Expected |
|----------|------|----------|
| Bet below minimum | Negative | Rejected |
| Bet above maximum | Negative | Rejected |
| Bet within limits | Positive | Accepted |
| Player-specific lower max | Positive | Uses lower limit |
