# 9. Platform Settings

**Page description:** Player site settings - layout, currency, language, registration, deposit/withdrawal.

### Section Overview:
- **9.1:** System Parameter Configuration
- **9.2:** Currency settings
- **9.3:** Language settings
- **9.4:** Registration, Deposit, Withdrawal settings
- **9.5:** Customized Themes
- **9.5.1:** Customize Theme details
- **9.6:** Customize Content
- **9.7:** Lobby Banner Setting

---

## 9.1 System Parameter Configuration

### Key Parameters

| Parameter | Description |
|-----------|-------------|
| DailyPlayerWithdrawalCount | Withdrawals per day (resets at backoffice timezone) |
| IsNotificationOfNewRegister | New register prompt sound |
| IsBankShowByDropDownList | Bank list as searchable dropdown |
| IsNotificationSoundAlertEnable | Deposit/withdrawal prompt sound |
| IsPaymentPasswordEnable | 4-digit withdrawal password required |
| IsShowPromoCodeOnPlayersite | Show/hide promotion codes |
| IsDisableIpv6InSystem | Block IPv6 users from register/login/promotion |
| IsDefaultCreatePromotionWallet | Default for IsCreatePromotionWallet |
| RegisterIpLimitPerHour | Registration limit per IP per hour |
| IsLoginByPhoneNumberEnable | Phone number login (after OTP) |
| IsWalletSelectionEnabled | Player chooses betting wallet |
| IsWithdrawalLimitEnabled | Calculate withdrawal flow limit |

### PasswordExpireDuration
- Days until password expires
- Countdown from registration or password change
- On expiry: redirect to change password
- "Never Expire" to disable

### PasswordHistoryCount
- Prevent reusing N previous passwords
- Example: Set to 2, cannot use last 2 passwords

### RebateWithdrawalLimitRatio
- Turnover ratio for VIP Rebate, Upgrade bonus, Promotion Rebate

### RiskControlCheckingPeriod
- Default: 90 days
- Same IP within period triggers detection

### WithdrawalLimitAutoCompletedByLosingPercentage
- Auto-complete withdrawal limit at X% loss

### WithdrawalLimitAutoCompletedByRemainingBalance
- Auto-complete when balance < threshold

### WithdrawalLimitRatio
- Player withdrawal rollover multiplier

### WithdrawalUnit
- Minimum withdrawal unit (e.g., Multiples of Ten)

---

## 9.2 Currency

### a. Set Website Currency
Enable currencies for the site.

**Note:** Contact AM for production currency. Test uses TMP currency.

### b. Min/Max Deposit and Withdrawal
Set amounts per currency.

### c. Manual Deposit/Withdrawal Settings

| Setting | Description |
|---------|-------------|
| Single manual withdrawal limit | Max per manual withdrawal |
| Total manual deposit limit | Total manual deposit cap (shared by all accounts) |

---

## 9.3 Language

Set player site display languages.

---

## 9.4 Registration Deposit and Withdrawal Settings

### Field Status Options

| Status | Description |
|--------|-------------|
| Disabled | Not shown |
| Optional | Shown, not required |
| Required | Shown, must fill |
| Be unique | Cannot duplicate other players |

### Captcha Settings

| Setting | Description |
|---------|-------------|
| LoginCaptcha | Required for login |
| RegisterCaptcha | Required for registration |
| DepositCaptcha | Required for deposit |
| WithdrawalCaptcha | Required for withdrawal |

### Redirect Page After Registration
- Home Page
- Deposit Page
- Promotion Page

### Currency Display Option
| Option | Behavior |
|--------|----------|
| Show | All currencies in dropdown |
| Hide | Set Default Currency, dropdown hidden |

### OTP Verification
- Methods: Email, SMS
- Apply: During registration, During first withdrawal

---

## 9.5 Customized Themes

Website layout settings for Mobile and Desktop (set separately).

---

## 9.5.1 Customize Theme

### Global Settings
- Company Settings (trademark, SEO, icon)
- Theme Color
- Header Style
- Product Category Dropdown
- Footer Style
- Login Page
- User Center
- Contacts Info
- Side Bar

### Lobby Setting
- Provider Type Module
- Live Casino Module
- Sport Module
- Games Module
- Promotion Module

### Product Category Setting
- Sport, Virtual Sports, Live Casino, Games
- Cockfighting, Lottery, Poker, Promotion pages

### Banner Settings
- Home Page: up to 10 banners
- Other pages: up to 6 banners
- Drag to adjust order

### Ad Settings
- Lobby Ads Left Side
- Login Advertisement
- Popup Ads (max 3)

---

## 9.6 Customize Content

### Customize Control - Toggles
- Show Registration Button
- Show Home Page
- Show Promotions
- Show News Tabs

### Homepage Settings
- Desktop/Mobile Default Home Page

### Live Chat
- Live Chat, Tawk.to (free), Respond.io
- Insert "Widget" code

### SEO
- Multiple SEO settings with unique titles
- Fields: Name, Page Path, Title, Keywords, Description, Og:image

### Event Tracking
- GTM, GA4, Facebook, Tiktok, Kwai

### Menu Setting
- Desktop Menu and Mobile Tab Bar
- Add, remove, reorder, rename items
- Real-time preview

#### Custom Page Link Types
| Type | Options |
|------|---------|
| Custom URL | Iframe or Pop-up |
| Website Function | Deposit, Withdrawal, Wallet, etc. |
| Product Type | Sports, Casino, etc. |
| Game Provider | Evolution, PGSoft, etc. |
| Games | Specific games |
| Game Type | Slot, Fishing, etc. |

---

## 9.7 Lobby Banner Setting

### Status
| Status | Description |
|--------|-------------|
| Enabled | Displayed |
| Disabled | Not displayed |
| Discontinue | Expired, suspended |

### Upload at Specific Time
Schedule banner display/removal.

### MP4 Upload
- Length: 6 seconds
- Size: Up to 2MB
- Dimensions: 1920 x 460px

---

## Test Scenarios

### System Parameters
| Scenario | Type | Expected |
|----------|------|----------|
| Exceed daily withdrawal count | Negative | Blocked |
| Password expired | Negative | Redirect to change |
| Reuse old password | Negative | Rejected |
| IPv6 disabled, IPv6 user tries | Negative | Blocked |
| Withdrawal limit auto-complete | Positive | Limit cleared |

### Registration
| Scenario | Type | Expected |
|----------|------|----------|
| Required field empty | Negative | Validation error |
| Unique field duplicate | Negative | Rejected |
| Captcha wrong answer | Negative | Blocked |
| OTP verification | Positive | Code sent, verified |

### Currency/Bank
| Scenario | Type | Expected |
|----------|------|----------|
| Withdraw below minimum | Negative | Rejected |
| Withdraw above maximum | Negative | Rejected |
| Manual deposit at limit | Negative | Blocked |
