# 11. Risk Control Management

**Page description:** Risk detection, alerts, IP blacklist, high-risk approval.

### Section Overview:
- **11.1:** IP/FP Detection
- **11.2:** Telegram Alerts
- **11.3:** IP Blacklist
- **11.4:** High-Risk Approval Thresholds
- **11.5:** Operation Approval

---

## 11.1 IP/FP Detection

Identify accounts sharing same IP or device fingerprint.

### Detection Types

| Type | Description |
|------|-------------|
| Same IP and FP | Accounts with both same IP and fingerprint |
| Same IP | Accounts sharing IP address |
| Same FP | Accounts sharing device fingerprint |

### Use Cases
- Risk control
- Fraud prevention
- Account behavior analysis

---

## 11.2 Telegram Alerts

Integrate with Telegram for real-time notifications.

### Alert Types

| Alert | Trigger Condition |
|-------|-------------------|
| Big Win | Win exceeds specified amount |
| Large Deposit | Deposit exceeds threshold |
| Large Withdrawal | Withdrawal exceeds threshold |
| Hourly Registration | Registrations per hour exceed count |
| Hourly Deposit | Deposits per hour exceed amount |
| Hourly Withdrawal | Withdrawals per hour exceed amount |
| Hourly Promotion Bonus | Bonus amount per hour exceeds threshold (excludes rebate) |
| Hourly Promotion Application | Applications per hour exceed count |

---

## 11.3 IP Blacklist

### Add IP Blacklist
- Supports IPv4 and IPv6
- Single IP or IP range
- Optional notes

### Player Site Behavior

| Action | Message |
|--------|---------|
| Register with blacklisted IP | "Account Unavailable" |
| Login with blacklisted IP | "Account Unavailable" |

### Back Office Display
- Player IP marked in **red**
- "Blacklist IP" noted
- Visible in: 3.1 Member List, 10.5 Member List, 11.1 IP/FP

---

## 11.4 High-Risk Approval Thresholds

### Description
Transactions at or above threshold require two-stage approval.

### Default Values (USD equivalent)

| Type | Default Threshold |
|------|-------------------|
| Deposit | 5,000 USD |
| Withdrawal | 2,500 USD |

Applies to: Bank Transfer, Payment Gateway, Manual Transfer

### Two-Stage Approval

| Stage | Who Can Approve |
|-------|-----------------|
| Stage One | Sub-account with Update permission (within threshold) |
| Stage Two | Company account OR sub-account with High Risk Approval Permission |

### Risk Warning Message
Appears for 3 days after increasing threshold.

| Option | Description |
|--------|-------------|
| Remind Me 30 Days Later | Warning in 30 days |
| Review & Edit | Redirect to 11.4 |
| Apply Recommended Settings | Reset to default |

### High Risk Approval Permission
Grant specific sub-accounts permission for Stage Two approval.

All actions logged in 3.8 Action Log.

---

## 11.5 Operation Approval

Review and approve high-risk transactions.

### Status Pages

| Status | Description |
|--------|-------------|
| Waiting | Request at/above threshold, pending approval |
| Approved | Previously approved requests |
| Rejected | Previously rejected requests |

---

## Test Scenarios

### IP/FP Detection
| Scenario | Type | Expected |
|----------|------|----------|
| Two accounts same IP | Positive | Flagged in Same IP |
| Two accounts same FP | Positive | Flagged in Same FP |
| Two accounts same IP+FP | Positive | Flagged in Same IP and FP |

### Telegram Alerts
| Scenario | Type | Expected |
|----------|------|----------|
| Win exceeds Big Win threshold | Positive | Alert sent |
| Withdrawal exceeds threshold | Positive | Alert sent |
| Hourly registrations spike | Positive | Alert sent |

### IP Blacklist
| Scenario | Type | Expected |
|----------|------|----------|
| Register from blacklisted IP | Negative | "Account Unavailable" |
| Login from blacklisted IP | Negative | "Account Unavailable" |
| Add IP range to blacklist | Positive | Range blocked |
| Remove IP from blacklist | Positive | IP unblocked |

### High-Risk Approval
| Scenario | Type | Expected |
|----------|------|----------|
| Withdrawal below threshold | Positive | Stage One only |
| Withdrawal at threshold | Negative | Stage Two required |
| Withdrawal above threshold | Negative | Stage Two required |
| Sub-account without permission tries Stage Two | Negative | Blocked |
| Company account approves Stage Two | Positive | Approved |
| Increase threshold above default | Positive | Risk warning for 3 days |
