# 12. Security

**Page description:** Password security policies and login security.

---

## Password Security Policy

### Back Office Password Visibility Icon
- Eye icon next to password field
- Click to show/hide password
- Available on:
  - Back Office Login
  - Create sub-account

---

## Back Office Login Security

### Two-Factor Authentication (2FA) Setup

**Prerequisite:** Download Google Authenticator app.

### Setup Steps:
1. Enter username and password
2. Leave 2FA field blank (first time), click Sign In
3. See 2FA setup screen
4. Open authenticator app
5. Choose "Enter a setup key" or "Scan QR code"
6. Enter 6-digit code in 2FA field
7. Click Login
8. **After setup:** Required for every login

---

## Player Site Security

### Password Rules

| Rule | Requirement |
|------|-------------|
| Length | 4-20 characters |
| Special characters | Allowed (! @ # $ % ^ & * ...) |
| Expiration | 60 days default (configurable) |
| History | 3 password cycle (cannot reuse) |
| Real-time validation | Feedback for non-compliant passwords |

### Password Expiration Error
"The new password must not be the same as your old password. Please choose a new one"

### Password Visibility Icon
- Available on:
  - Player Login
  - Player Register

### Player 2FA
- Optional in Account Security
- Required on every login after setup

---

## Account Lockout

| Trigger | Result |
|---------|--------|
| 3 wrong passwords | Account Closed automatically |

---

## Bank Info Security

| Condition | Bank Details |
|-----------|--------------|
| No successful transaction | Can edit |
| After successful deposit/withdrawal | Auto-saved, cannot edit |

---

## Contact Info Editability

| Field | Edit Limit |
|-------|------------|
| Phone | One time only |
| Email | One time only |
| WhatsApp | Can edit later |
| Line | Can edit later |

---

## Test Scenarios

### Back Office 2FA
| Scenario | Type | Expected |
|----------|------|----------|
| First login, setup 2FA | Positive | Setup screen shown |
| Enter correct 2FA code | Positive | Login successful |
| Enter wrong 2FA code | Negative | Login failed |
| Login after setup | Positive | 2FA required |

### Password Policy
| Scenario | Type | Expected |
|----------|------|----------|
| Password < 4 characters | Negative | Validation error |
| Password > 20 characters | Negative | Validation error |
| Password with special chars | Positive | Accepted |
| Reuse recent password | Negative | "Must not be same as old" |
| Password expired, login | Negative | Redirect to change |

### Account Lockout
| Scenario | Type | Expected |
|----------|------|----------|
| 1 wrong password | Positive | Try again |
| 2 wrong passwords | Positive | Try again |
| 3 wrong passwords | Negative | Account Closed |

### Bank Info
| Scenario | Type | Expected |
|----------|------|----------|
| New player edits bank | Positive | Can edit |
| After successful transaction | Negative | Cannot edit |

### Contact Info
| Scenario | Type | Expected |
|----------|------|----------|
| Edit phone first time | Positive | Saved |
| Edit phone second time | Negative | Blocked |
| Edit WhatsApp anytime | Positive | Can edit |
