# Development Guide

## Development Environment

| Setting | Value |
|---------|-------|
| WebId | 1 (1company) |
| Database | Check Monika project files |
| Queries | Always specify columns, never SELECT * |

## Finding Table Structures

**DO:** Check table definitions in Monika project
```
monika/Monika/Main/dbo/Tables/{TableName}.sql
```

**DON'T:** Query database with SELECT *

### Example: Check SiteMessage columns

```bash
# Find table file in Monika
Read: /projects/BackEnd/monika/monika/Monika/Main/dbo/Tables/SiteMessage.sql
```

## Using Artemis Debug Skill

Use `/artemis-debug-secure` for staging DB investigation when needed.

**Always specify columns:**
```sql
SELECT Id, WebId, Name, Status, CreatedOn
FROM SiteMessage WITH (NOLOCK)
WHERE WebId = 1
ORDER BY CreatedOn DESC
```

**Never:**
```sql
SELECT * FROM SiteMessage
```

## Memory Strategy

### During Implementation

When discovering patterns or domain knowledge:

1. **Complete the implementation first**
2. **Commit the code changes**
3. **Create/update memory files** for future sessions

### Memory Files

| File | Purpose |
|------|---------|
| `.memory/learnings.json` | Patterns and conventions discovered |
| `.memory/tables.md` | Table structures found |
| `.memory/domain/{feature}.md` | Feature-specific knowledge |

### Why Memory Matters

- Claude sessions can be deleted
- New chats have no context
- Memory files persist knowledge across sessions
- Reduces re-discovery time

## Workflow

```
1. Implement feature
   ↓
2. Test implementation
   ↓
3. Commit code changes
   ↓
4. Update memory/learnings
   ↓
5. Commit memory updates (separate commit)
```

## Code Standards

- No comments in production code
- Use templates from `/templates/`
- Follow Coloris/Monika conventions
- Always specify columns in queries
