# Batch Spawn Templates v3.0.0

Ready-to-use prompts for parallel agent execution.

---

## Spawn Group 1: Database

**Trigger:** Feature start

```markdown
## Task: Database Layer for {FEATURE_NAME}

You are the Monika DB Agent. Implement the database layer.

### Read First
1. `.memory/features/{feature}/specification.md`
2. `.memory/features/{feature}/api-contract.json`

### Create
1. **Tables** - in `monika/Monika/Main/dbo/Tables/`
   - Use proper data types
   - Include audit columns (CreatedOn, UpdatedOn, CreatedBy)
   - Add indexes for frequently queried columns

2. **Stored Procedures** - in `monika/Monika/Main/dbo/Stored Procedures/`
   - Version format: `{Service}_{Feature}_{Action}_1.0.0`
   - Include GetList, GetById, Create, Update, Delete
   - Use OFFSET/FETCH pagination
   - Return ErrorCode, ErrorMessage

3. **Registration** - in `monika/Monika/ApplicationSetting/Data/InsertData.sql`
   - Add sp_lookup entries for all SPs

### Update Status
After each component, update `.memory/features/{feature}/status.json`:
```json
{
  "db": {
    "tables": "completed",
    "procedures": "completed",
    "registration": "completed"
  }
}
```

### Write Schema
Save database schema to `.memory/features/{feature}/db-schema.sql`
```

---

## Spawn Group 2: Backend + Frontend (Parallel)

**Trigger:** `db.procedures == completed`

### 2a: Coloris Backend Agent

```markdown
## Task: Backend API for {FEATURE_NAME}

You are the Coloris BE Agent. Implement the backend API layer.

### Read First
1. `.memory/features/{feature}/specification.md`
2. `.memory/features/{feature}/api-contract.json`
3. `.memory/features/{feature}/db-schema.sql`

### Create (in order)

1. **Models** - in `Coloris.Core/Models/{Module}/`
   - Request DTO with validation
   - Response DTO matching api-contract
   - Item models for lists

2. **Repository** - in `Coloris.Core/Repository/{Module}/`
   - Inherit from BaseRepository
   - Call versioned SPs from db-schema
   - Use Dapper for data access

3. **Service** - in `Coloris.Core/Services/{Module}/`
   - Business validation logic
   - Call repository methods
   - Return proper error codes

4. **Controller** - in `Core.Api/Controllers/{Module}/`
   - [RoutePrefix("api/{feature}")]
   - [JwtFilter, LogFilter, AdminInfoFilter]
   - v1 and v2 endpoints

5. **DI Registration** - in startup/Autofac config

### Update Status
After each component, update `.memory/features/{feature}/status.json`:
```json
{
  "be": {
    "models": "completed",
    "repository": "completed",
    "service": "completed",
    "controller": "completed"
  }
}
```
```

### 2b: Kirby Frontend Agent (API Layer)

```markdown
## Task: Frontend API Layer for {FEATURE_NAME}

You are the Kirby FE Agent. Implement the frontend API layer only.
Do NOT create composable/component yet - that's Phase 3.

### Read First
1. `.memory/features/{feature}/specification.md`
2. `.memory/features/{feature}/api-contract.json`

### Create (in order)

1. **Models** - in `src/models/{module}/`
   - Interface for request: `I{Feature}Request`
   - Interface for response: `I{Feature}Response`
   - Class with ForDisplay getters: `{Feature}Model`

2. **apiCalling.ts** - add methods:
   ```typescript
   callGet{Feature}List(request: I{Feature}Request) {
     // return api.post('/api/{feature}/v2/get-list', request)
     return FakeAPI.get{Feature}List(request)
   }
   ```

3. **apis.ts** - add wrappers:
   ```typescript
   get{Feature}List(request: I{Feature}Request) {
     return getResponse(apiCalling.callGet{Feature}List(request))
   }
   ```

4. **FakeAPI.ts** - add fake data:
   ```typescript
   get{Feature}List(request: I{Feature}Request) {
     return Promise.resolve({
       ErrorCode: 0,
       ErrorMessage: 'Success',
       Data: { List: [...], TotalCount: 10 }
     })
   }
   ```

### Update Status
```json
{
  "fe": {
    "models": "completed",
    "apiCalling": "completed",
    "apis": "completed",
    "fakeData": "completed",
    "composable": "blocked",
    "component": "blocked",
    "router": "blocked"
  }
}
```
```

---

## Spawn Group 3: Frontend Integration

**Trigger:** `be.controller == completed`

```markdown
## Task: Frontend Integration for {FEATURE_NAME}

You are the Kirby FE Agent. Complete the frontend integration.
The API layer (models, apiCalling, apis, FakeData) is already done.

### Read First
1. `.memory/features/{feature}/specification.md`
2. `.memory/features/{feature}/api-contract.json`
3. Review existing: `src/models/{module}/`, `src/libraries/apis.ts`

### Create (in order)

1. **Composable** - in `src/composables/use{Feature}.ts`
   - Use `apis.get{Feature}List()` (NOT apiCalling)
   - Include useVariable for permissions
   - Include filterFormModel with reactive()
   - Include columns with IColumnsDynamic[]
   - Include useToggleTableHeaderColumn
   - Include getData, onSearch, onExport methods

2. **Component** - in `src/views/{module}/{Feature}.vue`
   - Use Element Plus components
   - Include filter form
   - Include data table with dynamic columns
   - Include pagination
   - Include export button

3. **Router** - in `src/router/index.ts`
   - Add route with authorizeRoute
   - Set proper meta (title, permissions)

### Update Status
```json
{
  "fe": {
    "models": "completed",
    "apiCalling": "completed",
    "apis": "completed",
    "fakeData": "completed",
    "composable": "completed",
    "component": "completed",
    "router": "completed"
  }
}
```
```

---

## Status File Template

Initialize at feature start:

```json
{
  "feature": "{feature-name}",
  "created": "{ISO timestamp}",
  "updated": "{ISO timestamp}",
  "db": {
    "tables": "pending",
    "procedures": "pending",
    "registration": "pending"
  },
  "be": {
    "models": "pending",
    "repository": "pending",
    "service": "pending",
    "controller": "pending"
  },
  "fe": {
    "models": "pending",
    "apiCalling": "pending",
    "apis": "pending",
    "fakeData": "pending",
    "composable": "pending",
    "component": "pending",
    "router": "pending"
  }
}
```

---

## Orchestrator Quick Commands

```markdown
# Initialize feature
mkdir -p .memory/features/{feature}
# Write specification.md, api-contract.json, status.json

# Spawn Phase 1
"Use Monika DB Agent with Spawn Group 1 template"

# Check completion
cat .memory/features/{feature}/status.json | jq '.db'

# Spawn Phase 2 (parallel)
"Spawn both Coloris BE Agent and Kirby FE Agent using Group 2 templates"

# Check BE completion
cat .memory/features/{feature}/status.json | jq '.be.controller'

# Spawn Phase 3
"Use Kirby FE Agent with Spawn Group 3 template"

# Final check
cat .memory/features/{feature}/status.json
# All should be "completed"
```
