# Shared Memory System

This document describes the shared memory system used for cross-agent communication.

## Memory Structure

```
~/.claude/skills/backoffice-fullstack/memory/
├── features/
│   └── {feature-name}/
│       ├── specification.md      # Feature requirements
│       ├── api-contract.json     # API schema
│       ├── db-schema.sql         # Database schema
│       └── status.json           # Implementation status
├── templates/
│   ├── fe-component.vue          # Vue component template
│   ├── be-controller.cs          # C# controller template
│   └── db-procedure.sql          # SQL procedure template
└── context/
    ├── current-task.json         # Active task info
    └── agent-status.json         # Agent availability
```

## Memory Operations

### Write Feature Spec
```json
{
  "feature": "player-notes",
  "description": "Allow operators to add notes to player profiles",
  "requirements": [
    "Create, read, update, delete notes",
    "Filter by date and operator",
    "Support rich text formatting"
  ],
  "layers": ["db", "be", "fe"]
}
```

### Write API Contract
```json
{
  "endpoint": "POST /api/player-note/v2/get-list",
  "request": {
    "WebId": "int",
    "PlayerId": "int",
    "PageIndex": "int",
    "PageSize": "int"
  },
  "response": {
    "ErrorCode": "int",
    "ErrorMessage": "string",
    "Data": {
      "List": "PlayerNoteItem[]",
      "TotalCount": "int"
    }
  }
}
```

### Write Status
```json
{
  "feature": "player-notes",
  "status": {
    "db": {
      "tables": "completed",
      "procedures": "in_progress"
    },
    "be": {
      "models": "completed",
      "repository": "pending",
      "service": "pending",
      "controller": "pending"
    },
    "fe": {
      "models": "completed",
      "api": "pending",
      "composable": "pending",
      "component": "pending"
    }
  },
  "lastUpdated": "2025-01-08T12:00:00Z"
}
```

## Cross-Agent Communication Flow

```
┌─────────────┐     Write Spec      ┌──────────────┐
│ Orchestrator│ ──────────────────> │ Shared Memory│
└─────────────┘                     └──────────────┘
       │                                   │
       │ Spawn Agents                      │ Read Spec
       ▼                                   ▼
┌─────────────┐     Read/Write      ┌──────────────┐
│  DB Agent   │ <────────────────── │ Shared Memory│
└─────────────┘                     └──────────────┘
       │                                   │
       │ Update Status                     │ Status Changed
       ▼                                   ▼
┌─────────────┐     Spawn on DB Done ┌──────────────┐
│ Orchestrator│ <─────────────────── │ Shared Memory│
└─────────────┘                      └──────────────┘
       │
       │ Spawn BE + FE Agents
       ▼
┌─────────────┐                     ┌─────────────┐
│  BE Agent   │                     │  FE Agent   │
└─────────────┘                     └─────────────┘
       │                                   │
       │ Read API Contract                 │ Read API Contract
       │ Write BE Status                   │ Write FE Status
       ▼                                   ▼
              ┌──────────────────────┐
              │    Shared Memory     │
              └──────────────────────┘
```

## Domain Knowledge Reference

All agents share access to domain knowledge in `knowledge/backoffice/`:

| Module | Knowledge File | Key Concepts |
|--------|----------------|--------------|
| Dashboard | 01-dashboard.md | Cap limit, metrics |
| Sub-Account | 02-sub-account.md | Permissions, IP whitelist |
| Membership | 03-membership.md | KYC, VIP, labels |
| Reports | 04-reports.md | Win/Lost, betting records |
| Financial | 05-financial-center.md | Deposit, withdrawal |
| Promotions | 06-promotions.md | Bonus, rebate, coupons |
| Referral | 07-referral.md | Referrer/referee |
| Games | 08-game-platform.md | Providers, bet limits |
| Settings | 09-platform-settings.md | System params |
| Cash Agent | 10-cash-agent.md | Agent hierarchy |
| Risk Control | 11-risk-control.md | IP/FP detection |
| Security | 12-security.md | 2FA, password policy |
