using Coloris.Controllers;
using Coloris.Filters;
using Coloris.Models.{Feature};
using Coloris.Services;
using System.Web.Http;

namespace Coloris.Controllers.BackOffice
{
    [RoutePrefix("api/back-office/{feature}"), LogFilter, JwtFilter, AdminInfoFilter]
    public class {Feature}Controller : BaseApiController
    {
        private readonly I{Feature}Service _{feature}Service;

        public {Feature}Controller(I{Feature}Service {feature}Service)
        {
            _{feature}Service = {feature}Service;
        }

        [HttpPost]
        [Route("get-list")]
        [Route("v2/get-list")]
        public ApiResponse<{Feature}ListResponse> GetList({Feature}ListRequest req)
        {
            if (Request.RequestUri.AbsolutePath.Contains("/v2/"))
            {
                var userData = req.GetUserData();
                req.WebId = userData.WebId;
                req.OperatorId = userData.CustomerId;
                req.SimulateId = userData.SimulateId;
            }

            if (IsValidationError<{Feature}ListRequest, {Feature}ListResponse>(req, out var responseError))
                return responseError;

            return new ApiResponse<{Feature}ListResponse>(_{feature}Service.GetList(req));
        }

        [HttpPost]
        [Route("get-by-id")]
        [Route("v2/get-by-id")]
        public ApiResponse<{Feature}DetailResponse> GetById({Feature}GetByIdRequest req)
        {
            if (Request.RequestUri.AbsolutePath.Contains("/v2/"))
            {
                var userData = req.GetUserData();
                req.WebId = userData.WebId;
            }

            if (IsValidationError<{Feature}GetByIdRequest, {Feature}DetailResponse>(req, out var responseError))
                return responseError;

            return new ApiResponse<{Feature}DetailResponse>(_{feature}Service.GetById(req.Id, req.WebId));
        }

        [HttpPost]
        [Route("create")]
        [Route("v2/create")]
        public ApiResponse<BaseResponse> Create({Feature}CreateRequest req)
        {
            if (Request.RequestUri.AbsolutePath.Contains("/v2/"))
            {
                var userData = req.GetUserData();
                req.WebId = userData.WebId;
                req.OperatorId = userData.CustomerId;
                req.SimulateId = userData.SimulateId;
            }

            if (IsValidationError<{Feature}CreateRequest, BaseResponse>(req, out var responseError))
                return responseError;

            return new ApiResponse<BaseResponse>(_{feature}Service.Create(req));
        }

        [HttpPost]
        [Route("update")]
        [Route("v2/update")]
        public ApiResponse<BaseResponse> Update({Feature}UpdateRequest req)
        {
            if (Request.RequestUri.AbsolutePath.Contains("/v2/"))
            {
                var userData = req.GetUserData();
                req.WebId = userData.WebId;
                req.OperatorId = userData.CustomerId;
                req.SimulateId = userData.SimulateId;
            }

            if (IsValidationError<{Feature}UpdateRequest, BaseResponse>(req, out var responseError))
                return responseError;

            return new ApiResponse<BaseResponse>(_{feature}Service.Update(req));
        }

        [HttpPost]
        [Route("delete")]
        [Route("v2/delete")]
        public ApiResponse<BaseResponse> Delete({Feature}DeleteRequest req)
        {
            if (Request.RequestUri.AbsolutePath.Contains("/v2/"))
            {
                var userData = req.GetUserData();
                req.WebId = userData.WebId;
                req.OperatorId = userData.CustomerId;
                req.SimulateId = userData.SimulateId;
            }

            if (IsValidationError<{Feature}DeleteRequest, BaseResponse>(req, out var responseError))
                return responseError;

            return new ApiResponse<BaseResponse>(_{feature}Service.Delete(req));
        }
    }
}
