using Newtonsoft.Json;
using System;
using System.Collections.Generic;

namespace Coloris.Models.{Feature}
{
    public class {Feature}ListRequest : IBoRequest
    {
        public int WebId { get; set; }
        public int OperatorId { get; set; }
        public int SimulateId { get; set; }
        public int PageIndex { get; set; } = 1;
        public int PageSize { get; set; } = 25;
        public string Keyword { get; set; }
        public DateTime? DateFrom { get; set; }
        public DateTime? DateTo { get; set; }
        public string Status { get; set; }
    }

    public class {Feature}GetByIdRequest : IBoRequest
    {
        public int Id { get; set; }
        public int WebId { get; set; }
        public int OperatorId { get; set; }
        public int SimulateId { get; set; }
    }

    public class {Feature}CreateRequest : IBoRequest
    {
        public int WebId { get; set; }
        public int OperatorId { get; set; }
        public int SimulateId { get; set; }
        public string Name { get; set; }
        public string Description { get; set; }
        public decimal Amount { get; set; }
    }

    public class {Feature}UpdateRequest : IBoRequest
    {
        public int Id { get; set; }
        public int WebId { get; set; }
        public int OperatorId { get; set; }
        public int SimulateId { get; set; }
        public string Name { get; set; }
        public string Description { get; set; }
        public decimal Amount { get; set; }
        public string Status { get; set; }
    }

    public class {Feature}DeleteRequest : IBoRequest
    {
        public int Id { get; set; }
        public int WebId { get; set; }
        public int OperatorId { get; set; }
        public int SimulateId { get; set; }
    }

    public class {Feature}ListResponse : BaseResponse
    {
        public List<{Feature}Item> Data { get; set; }
        public int TotalCount { get; set; }
    }

    public class {Feature}DetailResponse : BaseResponse
    {
        public {Feature}Item Data { get; set; }
    }

    public class {Feature}Item
    {
        public int Id { get; set; }
        public int WebId { get; set; }
        public string Name { get; set; }
        public string Description { get; set; }
        public decimal Amount { get; set; }
        public string Status { get; set; }
        public DateTime CreatedOn { get; set; }
        public string CreatedBy { get; set; }
        public DateTime ModifiedOn { get; set; }
        public string ModifiedBy { get; set; }
    }
}
