using Coloris.Models.{Feature};
using Coloris.Repository.DbBase;
using NLog;
using System.Collections.Generic;
using System.Linq;

namespace Coloris.Repository
{
    public interface I{Feature}Repository
    {
        {Feature}ListResponse GetList({Feature}ListRequest req);
        {Feature}DetailResponse GetById(int id, int webId);
        BaseResponse Create({Feature}CreateRequest req);
        BaseResponse Update({Feature}UpdateRequest req);
        BaseResponse Delete({Feature}DeleteRequest req);
    }

    public class {Feature}Repository : BaseRepository, I{Feature}Repository
    {
        protected override DBConfigNew dbContext
        {
            get { return DBConfigNewFactory.Get(DatabaseRole.MainDb); }
        }

        public {Feature}Repository(ILogger logger) : base(logger)
        {
        }

        public {Feature}ListResponse GetList({Feature}ListRequest req)
        {
            var result = GetData<{Feature}ListResponse>("Coloris_{Feature}_GetList", new
            {
                req.WebId,
                req.OperatorId,
                req.PageIndex,
                req.PageSize,
                req.Keyword,
                req.DateFrom,
                req.DateTo,
                req.Status
            }).FirstOrDefault();

            if (result != null)
                LogError(result, "Coloris_{Feature}_GetList");

            return result ?? new {Feature}ListResponse { ErrorCode = -1, ErrorMessage = "No response" };
        }

        public {Feature}DetailResponse GetById(int id, int webId)
        {
            return GetData<{Feature}DetailResponse>("Coloris_{Feature}_GetById", new
            {
                Id = id,
                WebId = webId
            }).FirstOrDefault();
        }

        public BaseResponse Create({Feature}CreateRequest req)
        {
            return GetData<BaseResponse>("Coloris_{Feature}_Create", new
            {
                req.WebId,
                req.OperatorId,
                req.Name,
                req.Description,
                req.Amount
            }).FirstOrDefault();
        }

        public BaseResponse Update({Feature}UpdateRequest req)
        {
            return GetData<BaseResponse>("Coloris_{Feature}_Update", new
            {
                req.Id,
                req.WebId,
                req.OperatorId,
                req.Name,
                req.Description,
                req.Amount,
                req.Status
            }).FirstOrDefault();
        }

        public BaseResponse Delete({Feature}DeleteRequest req)
        {
            return GetData<BaseResponse>("Coloris_{Feature}_Delete", new
            {
                req.Id,
                req.WebId,
                req.OperatorId
            }).FirstOrDefault();
        }
    }
}
