using Coloris.Models.{Feature};
using Coloris.Repository;
using NLog;
using System.Threading.Tasks;

namespace Coloris.Services
{
    public interface I{Feature}Service
    {
        {Feature}ListResponse GetList({Feature}ListRequest req);
        {Feature}DetailResponse GetById(int id, int webId);
        BaseResponse Create({Feature}CreateRequest req);
        BaseResponse Update({Feature}UpdateRequest req);
        BaseResponse Delete({Feature}DeleteRequest req);
    }

    public class {Feature}Service : I{Feature}Service
    {
        private readonly I{Feature}Repository _{feature}Repository;
        private readonly ILogger _logger;

        public {Feature}Service(
            I{Feature}Repository {feature}Repository,
            ILogger logger
        )
        {
            _{feature}Repository = {feature}Repository;
            _logger = logger;
        }

        public {Feature}ListResponse GetList({Feature}ListRequest req)
        {
            if (req.PageIndex <= 0) req.PageIndex = 1;
            if (req.PageSize <= 0) req.PageSize = 25;
            if (req.PageSize > 100) req.PageSize = 100;

            return _{feature}Repository.GetList(req);
        }

        public {Feature}DetailResponse GetById(int id, int webId)
        {
            return _{feature}Repository.GetById(id, webId);
        }

        public BaseResponse Create({Feature}CreateRequest req)
        {
            if (string.IsNullOrWhiteSpace(req.Name))
            {
                return new BaseResponse((int)ApiReturnError.ValidationError)
                {
                    ErrorMessage = "Name is required"
                };
            }

            return _{feature}Repository.Create(req);
        }

        public BaseResponse Update({Feature}UpdateRequest req)
        {
            var existing = _{feature}Repository.GetById(req.Id, req.WebId);
            if (existing == null || existing.ErrorCode != 0)
            {
                return new BaseResponse((int)ApiReturnError.NotFound);
            }

            return _{feature}Repository.Update(req);
        }

        public BaseResponse Delete({Feature}DeleteRequest req)
        {
            var existing = _{feature}Repository.GetById(req.Id, req.WebId);
            if (existing == null || existing.ErrorCode != 0)
            {
                return new BaseResponse((int)ApiReturnError.NotFound);
            }

            return _{feature}Repository.Delete(req);
        }
    }
}
