CREATE PROCEDURE [dbo].[Coloris_{Feature}_Create_1.0.0]
    @webId INT,
    @operatorId INT,
    @name NVARCHAR(100),
    @description NVARCHAR(500) = NULL,
    @amount DECIMAL(18, 2) = 0
AS
BEGIN
    SET NOCOUNT ON;

    DECLARE @operator NVARCHAR(50) = ''

    SELECT @operator = Username
    FROM Customer WITH (NOLOCK)
    WHERE WebId = @webId
    AND CustomerId = @operatorId
    AND (AccountType = 7 OR AccountType = 8)
    AND AgtId = 0

    IF (@operator = '')
    BEGIN
        SELECT 108 AS ErrorCode, 'Invalid Operator Id' AS ErrorMessage
        RETURN
    END

    IF (@name IS NULL OR @name = '')
    BEGIN
        SELECT 101 AS ErrorCode, 'Name is required' AS ErrorMessage
        RETURN
    END

    IF EXISTS (
        SELECT 1 FROM [dbo].[{Feature}] WITH (NOLOCK)
        WHERE [WebId] = @webId
        AND [Name] = @name
        AND [IsDeleted] = 0
    )
    BEGIN
        SELECT 102 AS ErrorCode, 'Name already exists' AS ErrorMessage
        RETURN
    END

    BEGIN TRAN

    DECLARE @insertedId TABLE (Id INT)

    INSERT INTO [dbo].[{Feature}]
    (
        [WebId],
        [Name],
        [Description],
        [Amount],
        [Status],
        [IsDeleted],
        [CreatedBy],
        [CreatedOn],
        [ModifiedBy],
        [ModifiedOn]
    )
    OUTPUT INSERTED.[Id] INTO @insertedId
    VALUES
    (
        @webId,
        @name,
        @description,
        @amount,
        'Active',
        0,
        @operator,
        GETDATE(),
        @operator,
        GETDATE()
    )

    IF @@ERROR <> 0
    BEGIN
        ROLLBACK
        SELECT -1 AS ErrorCode, 'Insert failed' AS ErrorMessage
        RETURN
    END

    COMMIT

    SELECT 0 AS ErrorCode, 'Success' AS ErrorMessage, Id AS NewId
    FROM @insertedId
END
GO
