CREATE PROCEDURE [dbo].[Coloris_{Feature}_Delete_1.0.0]
    @id INT,
    @webId INT,
    @operatorId INT
AS
BEGIN
    SET NOCOUNT ON;

    DECLARE @operator NVARCHAR(50) = ''

    SELECT @operator = Username
    FROM Customer WITH (NOLOCK)
    WHERE WebId = @webId
    AND CustomerId = @operatorId
    AND (AccountType = 7 OR AccountType = 8)
    AND AgtId = 0

    IF (@operator = '')
    BEGIN
        SELECT 108 AS ErrorCode, 'Invalid Operator Id' AS ErrorMessage
        RETURN
    END

    IF NOT EXISTS (
        SELECT 1 FROM [dbo].[{Feature}] WITH (NOLOCK)
        WHERE [Id] = @id
        AND [WebId] = @webId
        AND [IsDeleted] = 0
    )
    BEGIN
        SELECT 104 AS ErrorCode, 'Record not found' AS ErrorMessage
        RETURN
    END

    BEGIN TRAN

    UPDATE [dbo].[{Feature}]
    SET
        [IsDeleted] = 1,
        [Status] = 'Deleted',
        [ModifiedBy] = @operator,
        [ModifiedOn] = GETDATE()
    WHERE [Id] = @id
    AND [WebId] = @webId

    IF @@ERROR <> 0
    BEGIN
        ROLLBACK
        SELECT -1 AS ErrorCode, 'Delete failed' AS ErrorMessage
        RETURN
    END

    COMMIT

    SELECT 0 AS ErrorCode, 'Success' AS ErrorMessage
END
GO
