CREATE PROCEDURE [dbo].[Coloris_{Feature}_GetById_1.0.0]
    @id INT,
    @webId INT
AS
BEGIN
    SET NOCOUNT ON;

    IF NOT EXISTS (
        SELECT 1 FROM [dbo].[{Feature}] WITH (NOLOCK)
        WHERE [Id] = @id
        AND [WebId] = @webId
        AND [IsDeleted] = 0
    )
    BEGIN
        SELECT 104 AS ErrorCode, 'Record not found' AS ErrorMessage
        RETURN
    END

    SELECT 0 AS ErrorCode, 'Success' AS ErrorMessage

    SELECT
        [Id],
        [WebId],
        [Name],
        [Description],
        [Amount],
        [Status],
        [CreatedOn],
        [CreatedBy],
        [ModifiedOn],
        [ModifiedBy]
    FROM [dbo].[{Feature}] WITH (NOLOCK)
    WHERE [Id] = @id
    AND [WebId] = @webId
    AND [IsDeleted] = 0
END
GO
