CREATE PROCEDURE [dbo].[Coloris_{Feature}_GetList_1.0.0]
    @webId INT,
    @operatorId INT,
    @page INT,
    @rowCountPerPage INT,
    @keyword NVARCHAR(100) = NULL,
    @dateFrom DATETIME = NULL,
    @dateTo DATETIME = NULL,
    @status NVARCHAR(20) = NULL
AS
BEGIN
    SET NOCOUNT ON;

    DECLARE @operator NVARCHAR(50) = ''

    SELECT @operator = Username
    FROM Customer WITH (NOLOCK)
    WHERE WebId = @webId
    AND CustomerId = @operatorId
    AND (AccountType = 7 OR AccountType = 8)
    AND AgtId = 0

    IF (@operator = '')
    BEGIN
        SELECT 108 AS ErrorCode, 'Invalid Operator Id' AS ErrorMessage
        RETURN
    END

    DECLARE @result TABLE
    (
        [Id] INT,
        [WebId] INT,
        [Name] NVARCHAR(100),
        [Description] NVARCHAR(500),
        [Amount] DECIMAL(18, 2),
        [Status] NVARCHAR(20),
        [CreatedOn] DATETIME,
        [CreatedBy] NVARCHAR(50),
        [ModifiedOn] DATETIME,
        [ModifiedBy] NVARCHAR(50)
    )

    INSERT INTO @result
    SELECT
        [Id],
        [WebId],
        [Name],
        [Description],
        [Amount],
        [Status],
        [CreatedOn],
        [CreatedBy],
        [ModifiedOn],
        [ModifiedBy]
    FROM [dbo].[{Feature}] WITH (NOLOCK)
    WHERE [WebId] = @webId
    AND [IsDeleted] = 0
    AND (@keyword IS NULL OR [Name] LIKE '%' + @keyword + '%')
    AND (@dateFrom IS NULL OR [CreatedOn] >= @dateFrom)
    AND (@dateTo IS NULL OR [CreatedOn] <= @dateTo)
    AND (@status IS NULL OR [Status] = @status)

    SELECT 0 AS ErrorCode

    SELECT
        [Id],
        [WebId],
        [Name],
        [Description],
        [Amount],
        [Status],
        [CreatedOn],
        [CreatedBy],
        [ModifiedOn],
        [ModifiedBy],
        TotalCount = COUNT(1) OVER(),
        MaxPage = CASE
            WHEN COUNT(1) OVER() % @rowCountPerPage = 0
            THEN COUNT(1) OVER() / @rowCountPerPage
            ELSE COUNT(1) OVER() / @rowCountPerPage + 1
        END,
        ROW_NUMBER() OVER(ORDER BY CreatedOn DESC) AS RowNumber
    FROM @result
    ORDER BY RowNumber
    OFFSET (@page - 1) * @rowCountPerPage ROWS
    FETCH NEXT @rowCountPerPage ROWS ONLY
END
GO
