CREATE TABLE [dbo].[{Feature}]
(
    [Id] INT IDENTITY(1, 1) NOT NULL,
    [WebId] INT NOT NULL,
    [Name] NVARCHAR(100) NOT NULL,
    [Description] NVARCHAR(500) NULL,
    [Amount] DECIMAL(18, 2) NOT NULL DEFAULT 0,
    [Status] NVARCHAR(20) NOT NULL DEFAULT 'Active',
    [IsDeleted] BIT NOT NULL DEFAULT 0,
    [CreatedBy] NVARCHAR(50) NOT NULL,
    [CreatedOn] DATETIME NOT NULL DEFAULT GETDATE(),
    [ModifiedBy] NVARCHAR(50) NOT NULL,
    [ModifiedOn] DATETIME NOT NULL DEFAULT GETDATE(),
    CONSTRAINT [PK_{Feature}] PRIMARY KEY CLUSTERED ([Id] ASC)
)

CREATE NONCLUSTERED INDEX [IX_{Feature}_WebId]
ON [dbo].[{Feature}] ([WebId] ASC)
WHERE [IsDeleted] = 0

CREATE NONCLUSTERED INDEX [IX_{Feature}_Status]
ON [dbo].[{Feature}] ([WebId] ASC, [Status] ASC)
WHERE [IsDeleted] = 0
