# Eclair API Reference

Complete reference for all eclair REST API endpoints.

Base URL: `http://localhost:8080`
Authentication: HTTP Basic Auth (username: anything, password: your API password)

## Node Management

| Endpoint | Description | Parameters |
|----------|-------------|------------|
| `getinfo` | Get node information | - |
| `connect` | Connect to peer | `uri` or `nodeId` + `host` + `port` |
| `disconnect` | Disconnect from peer | `nodeId` |
| `peers` | List connected peers | - |
| `audit` | Get audit logs | `from`, `to` (timestamps) |
| `stop` | Stop the node | - |

## Channel Management

| Endpoint | Description | Parameters |
|----------|-------------|------------|
| `open` | Open channel | `nodeId`, `fundingSatoshis`, `pushMsat`?, `channelType`?, `announceChannel`? |
| `rbfopen` | RBF channel open | `channelId`, `targetFeerateSatByte`, `fundingFeeBudgetSatoshis`? |
| `splicein` | Add funds to channel | `channelId`, `amountIn`, `pushMsat`? |
| `spliceout` | Remove funds from channel | `channelId`, `amountOut`, `address` or `scriptPubKey` |
| `close` | Close channel gracefully | `channelId`, `scriptPubKey`?, `preferredFeerateSatByte`? |
| `forceclose` | Force close channel | `channelId`, `maxClosingFeerateSatByte`? |
| `bumpforceclose` | Bump force close fee | `channelId`, `confirmationPriority` |
| `channel` | Get channel info | `channelId` or `shortChannelId` |
| `channels` | List all channels | `nodeId`? (filter by peer) |
| `closedchannels` | List closed channels | `from`?, `to`?, `count`?, `skip`? |
| `allchannels` | Get all channel announcements | - |
| `allupdates` | Get all channel updates | `nodeId`? |
| `channelstats` | Get channel statistics | `from`?, `to`? |
| `channelbalances` | Get all channel balances | - |

## Invoices

| Endpoint | Description | Parameters |
|----------|-------------|------------|
| `createinvoice` | Create BOLT11 invoice | `description` or `descriptionHash`, `amountMsat`?, `expireIn`? |
| `getinvoice` | Get invoice by hash | `paymentHash` |
| `listinvoices` | List invoices | `from`?, `to`?, `count`? |
| `listpendinginvoices` | List unpaid invoices | `from`?, `to`? |
| `parseinvoice` | Parse BOLT11 invoice | `invoice` |
| `deleteinvoice` | Delete invoice | `paymentHash` |

## Payments

| Endpoint | Description | Parameters |
|----------|-------------|------------|
| `payinvoice` | Pay BOLT11 invoice | `invoice`, `amountMsat`?, `maxAttempts`?, `maxFeeFlatSat`?, `maxFeePct`?, `blocking`? |
| `payoffer` | Pay BOLT12 offer | `offer`, `amountMsat`, `quantity`?, `blocking`? |
| `sendtonode` | Keysend payment | `nodeId`, `amountMsat` |
| `sendtoroute` | Pay via specific route | `amountMsat`, `invoice`, `shortChannelIds` |
| `getsentinfo` | Get sent payment status | `id` or `paymentHash` |
| `getreceivedinfo` | Get received payment status | `paymentHash` or `invoice` |
| `listreceivedpayments` | List received payments | `from`?, `to`? |
| `usablebalances` | Get usable balances | - |

## Path Finding

| Endpoint | Description | Parameters |
|----------|-------------|------------|
| `findroute` | Find route to invoice | `invoice`, `amountMsat`? |
| `findroutetonode` | Find route to node | `nodeId`, `amountMsat` |
| `findroutebetweennodes` | Find route between nodes | `sourceNodeId`, `targetNodeId`, `amountMsat` |
| `node` | Get node info | `nodeId` |
| `nodes` | Get multiple nodes | `nodeIds`? |

## Fees

| Endpoint | Description | Parameters |
|----------|-------------|------------|
| `networkfees` | Get routing fees paid | `from`?, `to`? |
| `updaterelayfee` | Set relay fees | `nodeId` or `channelId`, `feeBaseMsat`, `feeProportionalMillionths` |

## On-Chain

| Endpoint | Description | Parameters |
|----------|-------------|------------|
| `getnewaddress` | Generate new address | - |
| `sendonchain` | Send on-chain | `address`, `amountSatoshis`, `confirmationTarget` or `feeRatePerByte` |
| `cpfpbumpfees` | CPFP bump fees | `targetFeerateSatByte`, `outPoints` |
| `onchainbalance` | Get on-chain balance | - |
| `onchaintransactions` | List on-chain txs | `count`?, `skip`? |
| `globalbalance` | Get total balance | - |
| `getmasterxpub` | Get master xpub | `account`? |
| `getdescriptors` | Get wallet descriptors | `account`? |

## Messages

| Endpoint | Description | Parameters |
|----------|-------------|------------|
| `signmessage` | Sign message with node key | `msg` (base64) |
| `verifymessage` | Verify signed message | `msg` (base64), `sig` (hex) |
| `sendonionmessage` | Send onion message | `recipientNode`, `intermediateNodes`?, `content`?, `expectsReply`? |

## Offers (BOLT12)

| Endpoint | Description | Parameters |
|----------|-------------|------------|
| `createoffer` | Create BOLT12 offer | `description`, `amountMsat`? |
| `disableoffer` | Disable offer | `offer` |
| `listoffers` | List active offers | - |

## WebSocket

Connect to `ws://localhost:8080/ws` for real-time events:
- PaymentEvent (sent/received/failed)
- ChannelCreated, ChannelOpened, ChannelStateChanged, ChannelClosed
- OnionMessages.ReceiveMessage

## Example curl Commands

```bash
# Get node info
curl -u :password http://localhost:8080/getinfo

# Create invoice
curl -u :password \
  -F "description=coffee" \
  -F "amountMsat=100000000" \
  http://localhost:8080/createinvoice

# Pay invoice
curl -u :password \
  -F "invoice=lntb1m1..." \
  http://localhost:8080/payinvoice

# Open channel
curl -u :password \
  -F "nodeId=03..." \
  -F "fundingSatoshis=1000000" \
  http://localhost:8080/open

# Close channel
curl -u :password \
  -F "channelId=abc123..." \
  http://localhost:8080/close
```

## Notes

- All amounts in `msat` are millisatoshis (1/1000 of a satoshi)
- All amounts in `Satoshis` are satoshis
- Timestamps are Unix seconds
- Channel IDs are hex-encoded 32-byte values
- Short channel IDs format: `blockheight:txindex:outputindex`
