#!/bin/bash
# Wrapper for bitcoin-cli commands in the bitcoind container
#
# Usage:
#   bitcoin-cli.sh <command> [args...]
#
# Examples:
#   bitcoin-cli.sh getblockchaininfo
#   bitcoin-cli.sh getnewaddress
#   bitcoin-cli.sh sendtoaddress <address> <amount>
#   bitcoin-cli.sh getbalance

BITCOIND_CONTAINER="${BITCOIND_CONTAINER:-bitcoind}"

if [ $# -eq 0 ] || [ "$1" = "-h" ] || [ "$1" = "--help" ]; then
    echo "Usage: bitcoin-cli.sh <command> [args...]"
    echo ""
    echo "Wrapper for bitcoin-cli in the bitcoind container."
    echo ""
    echo "Common commands:"
    echo "  getblockchaininfo     Get blockchain status"
    echo "  getbalance            Get wallet balance"
    echo "  getnewaddress         Generate new address"
    echo "  sendtoaddress A N     Send N BTC to address A"
    echo "  generatetoaddress N A Mine N blocks to address A"
    echo "  getmempoolinfo        Get mempool status"
    echo "  getrawtransaction TX  Get raw transaction"
    echo ""
    echo "Examples:"
    echo "  bitcoin-cli.sh getblockchaininfo"
    echo "  bitcoin-cli.sh sendtoaddress bc1q... 0.5"
    exit 0
fi

docker exec "$BITCOIND_CONTAINER" bitcoin-cli -regtest -rpcuser=bitcoin -rpcpassword=bitcoin "$@"
