#!/bin/bash
# Quick build from GitHub PR
#
# Usage:
#   build-pr.sh <pr-number>
#   build-pr.sh 3144
#
# This is a convenience wrapper around docker-build.sh that:
# 1. Checks out the specified PR
# 2. Builds with a tag like eclair:pr-<number>
# 3. Provides instructions for running

set -e

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"

if [ -z "$1" ]; then
    echo "Usage: build-pr.sh <pr-number>"
    echo ""
    echo "Examples:"
    echo "  build-pr.sh 3144    # Build PR #3144 (taproot feature bit)"
    exit 1
fi

PR_NUMBER="$1"
shift

echo "Building eclair from PR #$PR_NUMBER..."
echo ""

"$SCRIPT_DIR/docker-build.sh" --pr "$PR_NUMBER" --tag "eclair:pr-$PR_NUMBER" "$@"

echo ""
echo "To run with docker-compose using this image:"
echo "  ECLAIR_IMAGE=eclair:pr-$PR_NUMBER docker-compose up -d"
