#!/bin/bash
# Stop eclair development environment
#
# Usage:
#   docker-stop.sh [options]
#
# Options:
#   --clean    Remove volumes (WARNING: deletes all data)
#   --compose  Stop docker-compose stack (default)
#   --container  Stop standalone container

set -e

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
TEMPLATES_DIR="$SCRIPT_DIR/../templates"

MODE="compose"
CLEAN=false

# Parse arguments
while [[ $# -gt 0 ]]; do
    case $1 in
        --clean)
            CLEAN=true
            shift
            ;;
        --compose)
            MODE="compose"
            shift
            ;;
        --container)
            MODE="container"
            shift
            ;;
        -h|--help)
            echo "Usage: docker-stop.sh [options]"
            echo ""
            echo "Options:"
            echo "  --clean       Remove volumes (WARNING: deletes all data)"
            echo "  --compose     Stop docker-compose stack (default)"
            echo "  --container   Stop standalone container"
            exit 0
            ;;
        *)
            echo "Unknown option: $1"
            exit 1
            ;;
    esac
done

if [ "$MODE" = "compose" ]; then
    cd "$TEMPLATES_DIR"

    if [ "$CLEAN" = true ]; then
        echo "Stopping stack and removing volumes..."
        docker-compose down -v
        echo "Stack stopped and volumes removed."
    else
        echo "Stopping stack..."
        docker-compose down
        echo "Stack stopped. Data preserved in volumes."
    fi
else
    echo "Stopping eclair container..."
    docker stop eclair 2>/dev/null || echo "Container not running"

    if [ "$CLEAN" = true ]; then
        echo "Removing eclair container..."
        docker rm eclair 2>/dev/null || true
    fi
fi

echo "Done."
