# Mutation Testing Report

**Date**: {{DATE}}
**Package**: {{PACKAGE}}
**Files Tested**: {{FILE_COUNT}}

---

## Summary

| Metric | Value |
|--------|-------|
| Total Mutations | {{TOTAL_MUTATIONS}} |
| Killed | {{KILLED}} ({{KILLED_PERCENT}}%) |
| Survived | {{SURVIVED}} ({{SURVIVED_PERCENT}}%) |
| Timeouts | {{TIMEOUTS}} |
| Errors | {{ERRORS}} |
| **Mutation Score** | **{{MUTATION_SCORE}}%** |
| Duration | {{DURATION}} seconds |

---

## Quality Assessment

{{QUALITY_BADGE}}

{{QUALITY_MESSAGE}}

---

## Surviving Mutants

{{#if_survivors}}
The following mutants survived testing, indicating potential gaps in test coverage:

{{#each survivors}}
### {{INDEX}}. {{FILE}}:{{LINE}}

**Mutation**: {{DESCRIPTION}}
**ID**: {{MUTATION_ID}}
**Type**: {{TYPE}}
**Priority**: {{PRIORITY}}

**Original Code**:
```go
{{ORIGINAL_CONTEXT}}
```

**Mutated Code**:
```go
{{MUTATED_CONTEXT}}
```

**Why It Survived**: {{ANALYSIS}}

**Recommended Test**:
```go
{{RECOMMENDED_TEST}}
```

---

{{/each}}

{{else}}
🎉 **All mutants were killed!** Your test suite successfully caught all introduced mutations.

This indicates excellent test quality with comprehensive assertions and edge case coverage.

{{/if_survivors}}

---

## Mutation Breakdown by Type

| Mutation Type | Generated | Killed | Survived | Score |
|---------------|-----------|--------|----------|-------|
{{#each mutation_types}}
| {{TYPE}} | {{TOTAL}} | {{KILLED}} | {{SURVIVED}} | {{SCORE}}% |
{{/each}}

---

## Mutation Breakdown by File

| File | Mutations | Killed | Survived | Score |
|------|-----------|--------|----------|-------|
{{#each files}}
| {{FILE}} | {{TOTAL}} | {{KILLED}} | {{SURVIVED}} | {{SCORE}}% |
{{/each}}

---

## High-Priority Survivors

These surviving mutants are in critical code paths and should be addressed first:

{{#each high_priority_survivors}}
- **{{FILE}}:{{LINE}}** - {{DESCRIPTION}} ({{PRIORITY}} priority)
{{/each}}

---

## Recommendations

Based on the mutation testing results:

### Immediate Actions

{{#if low_score}}
1. **Add edge case tests**: Focus on boundary conditions and off-by-one errors
2. **Strengthen assertions**: Verify actual outputs, not just absence of errors
3. **Test error paths**: Add negative test cases for error handling
{{/if}}

{{#if boundary_survivors}}
4. **Boundary testing needed**: {{BOUNDARY_COUNT}} boundary mutations survived
   - Add tests for exact threshold values
   - Test both sides of comparisons (< vs <=, > vs >=)
{{/if}}

{{#if logical_survivors}}
5. **Logical operator coverage**: {{LOGICAL_COUNT}} logical mutations survived
   - Add truth table tests for complex conditions
   - Test all combinations of boolean conditions
{{/if}}

{{#if arithmetic_survivors}}
6. **Arithmetic validation**: {{ARITHMETIC_COUNT}} arithmetic mutations survived
   - Verify calculation results with specific values
   - Test overflow/underflow scenarios
{{/if}}

### Long-Term Improvements

- Consider property-based testing for key functions
- Add fuzz tests for input validation
- Review test assertions to ensure they verify behavior
- Run mutation testing regularly in CI/CD

---

## Detailed Results

{{#if show_all_results}}
### All Mutations

{{#each all_results}}
#### {{MUTATION_ID}}: {{DESCRIPTION}}

- **File**: {{FILE}}:{{LINE}}
- **Type**: {{TYPE}}
- **Status**: {{STATUS}}
- **Duration**: {{DURATION}}ms

{{#if test_output}}
<details>
<summary>Test Output</summary>

```
{{TEST_OUTPUT}}
```
</details>
{{/if}}

---

{{/each}}
{{/if}}

---

## Configuration

- Test timeout: {{TIMEOUT}} seconds
- Test package: {{PACKAGE}}
- Parallel executions: {{PARALLEL}}
- Mutation tool: go/ast based custom mutator

---

## Next Steps

1. Review surviving mutants and determine if they are equivalent
2. Add targeted tests to kill high-priority survivors
3. Re-run mutation testing to verify improvements
4. Update test suite to maintain {{TARGET_SCORE}}% mutation score

---

Generated by mutation-tester agent | [View Mutation Operators Reference]({{MUTATION_OPERATORS_LINK}})
