# Log Files Reference

Complete reference for B2C Commerce log file types, locations, and management.

## Log File Types

### Custom Log Files

Custom log files are generated by script logging:

| Log File | Trigger | Default State |
|----------|---------|---------------|
| `customdebug` | `Logger.debug()` or `log.debug()` | Disabled |
| `custominfo` | `Logger.info()` or `log.info()` | Disabled |
| `customwarn` | `Logger.warn()` or `log.warn()` | Always enabled |
| `customerror` | `Logger.error()` or `log.error()` | Always enabled |
| `customfatal` | `log.fatal()` | Always enabled |

### System Log Files

System log files are generated by the platform:

| Log File | Description |
|----------|-------------|
| `error` | System errors in scripts, templates, and platform |
| `warn` | Lock status, slot warnings, servlet warnings |
| `info` | System information from scripts and platform |
| `debug` | Debug information (only when debug flag enabled) |
| `fatal` | Critical system failures |
| `api` | API problems and violations |
| `deprecation` | Usage of deprecated APIs |
| `jobs` | Job status information |
| `staging` | Replication process information |
| `quota` | Quota warnings and limits |
| `sql` | SQL and replication issues |
| `syslog` | API processing, staging, import/export info |
| `sysevent` | Appserver registration, cartridge logs |
| `analytics` | Analytics activity and errors |
| `performance` | Internal performance data |
| `console` | Internal console entries |
| `migration` | Internal migration data |
| `dbinit-sql` | SQL used during database initialization |

### Custom Named Log Files

Files created with `Logger.getLogger(prefix, category)`:

```
custom-<prefix>-<hostname>-appserver-<date>.log
```

Example: `custom-orderexport-blade0-1-appserver-20240115.log`

## Log File Locations

### WebDAV Access

**Logs Directory:**
```
https://<instance>.demandware.net/on/demandware.servlet/webdav/Sites/Logs
```

**Security Logs:**
```
https://<instance>.demandware.net/on/demandware.servlet/webdav/Sites/Securitylogs
```

**Import/Export Logs:**
```
https://<instance>.demandware.net/on/demandware.servlet/webdav/Sites/Impex/log
```

### Business Manager Access

1. **Administration > Site Development > Development Setup**
2. Scroll to **WebDAV Access** section
3. Click **Log files** link

## Log Retention

| Environment | Retention | Notes |
|-------------|-----------|-------|
| Production | 30 days | Auto-deleted after retention |
| Staging | 30 days | Auto-deleted after retention |
| Development | Not defined | Manual cleanup recommended |
| Sandbox | Not defined | Manual cleanup recommended |

**Security logs** are retained for 90 days.

### Archive Process

- After 3 days, logs move to `log_archive` directory
- Archived logs are compressed to gzip format
- Download logs locally for longer retention

## Storage Limits

### Custom Log Size Limits

| Limit | Value |
|-------|-------|
| Per log level per day | 10 MB |
| Per application server | Per log type |
| Custom named log files | Same 10 MB limit |

When the limit is reached:
```
+++++++++++ Maximum log file size per day reached, logging suspended. +++++++++++
```

Logging resumes at 00:00 GMT the next day.

### File Count Limits

- Maximum 100,000 files per folder
- Excess files deleted starting with oldest
- Applies per folder, not across subfolders

### Custom Log File Quota

- Maximum 200 different log file prefixes per day
- Per application server
- Hard limit (throws exception when exceeded)

## Log Entry Format

### Standard Format

```
[timestamp GMT] [level] [category] message
```

Example:
```
[2024-01-15 10:30:45.123 GMT] [INFO] [checkout] Order ORD123 submitted
```

### With NDC

```
[timestamp GMT] [level] [category] [ndc-context] message
```

Example:
```
[2024-01-15 10:30:45.123 GMT] [INFO] [checkout] [Order:123 Payment] Processing payment
```

## Redundancy Tracking

Error and Warning messages are tracked for redundancy:

- Messages appearing > 10 times in 3 minutes are suppressed
- Suppression lasts 3 minutes
- Suppression message:

```
The following message was generated more than 10 times within the last 180 seconds.
It will be suppressed for 180 seconds:
<original message>
```

## Quota Log Format

Quota logs show when thresholds or limits are exceeded:

```
[timestamp] [thread-info] Quota quota.name (enforced, warn threshold, limit):
warn threshold exceeded N time(s), max actual was X, current location: details
```

Example:
```
[2024-01-15 13:00:22.577 GMT] [RequestHandlerServlet|14320460|Sites-MySite|Product-Show|...]
Quota api.jsStringLength (enforced, warn 600000, limit 1000000): warn threshold exceeded 1 time(s),
max actual was 600010, current location: request/site Sites-MySite/top pipeline Product-Show/
interaction node/template default.CustomDisplay
```

## Security Log Format

```
[timestamp GMT][dw-sec] (User: 'username' (realm), IP: x.x.x.x [ACTION] : details)
```

Example:
```
[2024-01-15 02:23:19.139 GMT][dw-sec] (User: 'admin' (Sites), IP: 192.168.1.1 [LOGIN] : logged in.)
```

Actions logged:
- LOGIN
- LOGOUT
- LOGIN_FAILED
- PASSWORD_CHANGED
- Re-login (session timeout)

## Import/Export Logs

Located in `/Impex/log/`:

| Log Type | Description |
|----------|-------------|
| Catalog | Catalog import/export logs |
| Customer | Customer batch processing logs |
| Inventory | Inventory import logs |
| Price Book | Price book import/validation logs |
| Promotion | Promotion validation logs |
| Metadata | Metadata validation logs |
| Coupon | Coupon validation logs |

Example path:
```
/Impex/log/Batch-Customer-20240115192425062.log
```

## Accessing Logs Programmatically

### Via WebDAV Client

Configure your WebDAV client with:
- URL: `https://<instance>/on/demandware.servlet/webdav/Sites/Logs`
- User: Business Manager username
- Password: Business Manager password

### Via B2C CLI

```bash
# Download logs via WebDAV
b2c webdav pull /Logs --dest ./local-logs

# Download specific log
b2c webdav pull /Logs/customerror-blade0-1-20240115.log
```

## Debug Logging on Production

Debug logging is **never enabled on production instances**.

On non-production instances:
- Debug logs are "in-memory" by default
- Enables "Show Request Log" feature
- Does not generate log files unless explicitly enabled

## Best Practices

### 1. Monitor Log File Sizes

Check log sizes regularly to avoid hitting limits:
- 10 MB per custom log type per day
- Monitor during high-traffic periods

### 2. Use Custom Named Logs for Integrations

```javascript
// Separate files for each integration
var erpLog = Logger.getLogger('erp-sync', 'erp');
var paymentLog = Logger.getLogger('payment-gateway', 'payment');
```

### 3. Clean Up Old Logs

- Delete unnecessary logs promptly
- Don't exceed 100,000 files per folder
- Download and archive important logs locally

### 4. Configure Categories in Business Manager

1. Go to **Administration > Operations > Custom Log Settings**
2. Add categories for your code areas
3. Enable appropriate log levels per category
4. Set up fatal email notifications

### 5. Use Appropriate Log Levels

| Level | Use For |
|-------|---------|
| debug | Development debugging only |
| info | Notable events, job progress |
| warn | Recoverable issues, slow operations |
| error | Failures requiring attention |
| fatal | Critical failures, email notification |
