---
name: aegis-architect
displayName: Aegis Architect
description: アーキタイプベースのスキャフォールドツール - プロジェクトの重さに応じた型を選択
allowed-tools:
  - aegis-skills__run_script
allowedRoles:
  - architect
  - senior-developer
  - admin
---

# Aegis Architect

**AIをコーダーからオペレーターへ変える**

このスキルは「たい焼きの型」です。どんなAIが使っても、選んだアーキタイプに従った正しい構造が生成されます。

## コンセプト

```
Before (プロンプト依存):
  AI: 「ファイル作ります...あれ、どこに置こう？まあここでいいか」
  → 結果: 構造が崩れる

After (Aegis Architect):
  AI: 「aegis-architect scaffold --name stock_price」を実行
  Aegis: (ガシャン！) 3ファイルを強制生成
  → 結果: 誰がやっても100%正しい構造
```

## アーキタイプ（型の選択）

プロジェクトの「重さ」に応じて適切な型を選択します。

| アーキタイプ | 用途 | 生成ファイル |
|-------------|------|-------------|
| `rust_hexagonal` | 堅牢なコアシステム | Domain/Port/Adapter (3ファイル) |
| `rust_cli_simple` | 小さなCLIツール | main.rs + Cargo.toml |

### 選び方

```
「長期運用？外部依存の差し替え？チーム開発？」
  → YES: rust_hexagonal

「単機能のCLIツール？学習目的？PoC？」
  → YES: rust_cli_simple
```

## 使い方

### ビルド

```bash
cd aegis-architect-rs
cargo build --release
```

### アーキタイプ一覧を確認

```bash
aegis-architect list
```

### Hexagonal構造で生成（デフォルト）

```bash
aegis-architect scaffold \
  --name market_analysis \
  --description "株価を分析する機能" \
  --target ./aegis-core
```

### シンプルなCLIツールとして生成

```bash
aegis-architect scaffold \
  --name my_tool \
  --description "便利ツール" \
  --archetype rust_cli_simple
```

### アーキタイプディレクトリを指定

```bash
aegis-architect --archetypes-dir /path/to/archetypes scaffold ...
```

## 生成されるファイル構造（rust_hexagonal）

```
target/
├── src/domain/market_analysis.rs      # 聖域：純粋なドメインモデル
├── src/ports/market_analysis_port.rs  # インターフェース定義
└── src/adapters/market_analysis_adapter.rs  # 実装の雛形
```

## 設計原則（rust_hexagonal）

```
┌─────────────────────────────────────────┐
│              Domain (Core)              │
│  - 外部依存ゼロ                         │
│  - 純粋な構造体とビジネスロジック       │
│  - ここが「聖域」                       │
└─────────────────────────────────────────┘
                    ▲
                    │ 依存の方向
                    │
┌─────────────────────────────────────────┐
│              Ports (Traits)             │
│  - Domainの型を使うインターフェース     │
│  - 外部との境界を定義                   │
└─────────────────────────────────────────┘
                    ▲
                    │
┌─────────────────────────────────────────┐
│           Adapters (実装)               │
│  - Portを実装                           │
│  - 外部API/DB/ファイルシステムへ接続    │
│  - ここだけが「汚れてよい」             │
└─────────────────────────────────────────┘
```

## なぜツールで強制するのか

| アプローチ | 問題点 |
|-----------|--------|
| 設計書を書く | 読まれない、守られない |
| プロンプトで指示 | AIは忘れる、解釈がブレる |
| コードレビュー | 事後対応、手戻りが発生 |
| **ツールで強制** | 物理的に正しい構造しか作れない |

## 使用例

```
ユーザー: 「株価取得機能を追加して」

AI（Aegis Architect使用）:
1. プロジェクトの規模を判断 → AEGIS本体なのでrust_hexagonalを選択
2. aegis-architect scaffold --name stock_price を実行
3. 生成された domain/stock_price.rs にドメインモデルを定義
4. ports/stock_price_port.rs にトレイトメソッドを追加
5. adapters/stock_price_adapter.rs に実装を書く

→ 手順を飛ばしたり、構造を無視することが不可能
```

## アーキタイプの追加方法

新しいアーキタイプを追加するには:

1. `archetypes/<name>/` ディレクトリを作成
2. `manifest.json` でメタデータと生成ファイルを定義
3. テンプレートファイル (`.tmpl`) を配置

テンプレートでは `{{ name }}`, `{{ pascal_name }}`, `{{ description }}` が使用可能。

## 今後の拡張

- [ ] validate_arch - 既存コードのアーキテクチャ違反検出
- [ ] migrate_to_hex - レガシーコードの移行支援
- [ ] テスト雛形の自動生成
- [ ] CI連携（PRでvalidate_archを自動実行）
